<?php

if (!function_exists("vcwccr_products_redirect")) {

	add_action('template_redirect', 'vcwccr_products_redirect');

	function vcwccr_products_redirect() {

		global $post;

		if (is_product()) {

			//validating settings and restrictions
			if (!apply_filters('wcacr_allow_to_hide_products', true) || (!vcwccr_is_restricted($post->ID) && vcwccr_shop_is_available())) {
				return;
			} else {
				//if country is not available error page is shown				
				$message = __("Sorry, This product is not available for your country", VCWCCR_TEXT_DOMAIN);

				//If you want to use your own template, here is the filter
				$products_not_available_template = apply_filters("vcwccr_not_available_template", plugin_dir_path(__DIR__) . "views/frontend/product-not-available-page.php", $message);

				require_once $products_not_available_template;
				die;
			}
		}
	}

}

if (!function_exists("vcwccr_custom_pre_get_posts_query")) {

	add_action('woocommerce_product_query', 'vcwccr_custom_pre_get_posts_query');

	function vcwccr_custom_pre_get_posts_query($q) {
		if (is_product_category()) {

			$term_id = $q->queried_object->term_id;

			$apply_operator = get_term_meta($term_id, "vcwccr_apply_this_to", true);

			if ($apply_operator !== "products_only") {

				if (vcwccr_is_restricted($term_id, "category")) {

					$q->set_404();
					return;
				}
			}
		}

		if (!apply_filters('wcacr_allow_to_hide_products', true)) {
			return;
		}

		do_action('wcacr_filter_products_query', $q);

		if (!vcwccr_shop_is_available()) {

			if (is_shop()) {
				$q->set('post__in', array(0));
			}

			return;
		}

		return;
	}

}

if (!function_exists("vcwccr_exclude_disallowed_products")) {

	add_action('pre_get_posts', 'vcwccr_exclude_disallowed_products');

	function vcwccr_exclude_disallowed_products($q) {

		if (!apply_filters('wcacr_allow_to_hide_products', true)) {
			return;
		}
		$disallowed_products = vcwccr_get_disallowed_products();

		if (!empty($disallowed_products)) {
			$q->set('post__not_in', $disallowed_products);

			if (!empty($q->get('post__in'))) {
				$q->set('post__in', array_diff($q->get('post__in'), $disallowed_products));
			}
		}
	}

}

if (!function_exists("vcwccr_exclude_products_from_search")) {

	add_filter('register_post_type_args', 'vcwccr_exclude_products_from_search', 10, 2);

	function vcwccr_exclude_products_from_search($args, $post_type) {

		if ($post_type === "product" && apply_filters('wcacr_allow_to_hide_products', true)) {
			if (vcwccr_shop_is_available()) {
				$args["exclude_from_search"] = false;
			} else {
				$args["exclude_from_search"] = true;
			}
		}

		return $args;
	}

}

if (!function_exists("vcwccr_remove_restricted_products_from_grouped_product")) {

	add_action('woocommerce_before_single_product', 'vcwccr_remove_restricted_products_from_grouped_product');

	function vcwccr_remove_restricted_products_from_grouped_product() {

		global $product;

		$grouped_product_available_products = array();

		if ($product->get_type() == 'grouped') {

			$grouped_products = $product->get_children();

			if (empty($grouped_products)) {
				return;
			}

			foreach ($grouped_products as $grouped_product) {

				if (vcwccr_is_restricted($grouped_product)) {
					continue;
				}

				$grouped_product_available_products[] = $grouped_product;
			}

			$product->set_children($grouped_product_available_products);
		}
	}

}

if (!function_exists("vcwccr_remove_restricted_products_from_related_products")) {

	add_filter("woocommerce_related_products", "vcwccr_remove_restricted_products_from_related_products");

	function vcwccr_remove_restricted_products_from_related_products($related_posts) {

		if (empty($related_posts)) {
			return $related_posts;
		}

		$available_related_posts = array();

		foreach ($related_posts as $related_post) {

			if (!vcwccr_is_restricted($related_post)) {
				$available_related_posts[] = $related_post;
			}
		}

		return $available_related_posts;
	}

}

//Applying restrictions to the widget
if (!function_exists("vcwccr_products_widget")) {

	add_filter("woocommerce_products_widget_query_args", "vcwccr_products_widget");

	function vcwccr_products_widget($query_args) {

		if (!apply_filters('wcacr_allow_to_hide_products', true)) {
			return $query_args;
		}
		if (!vcwccr_shop_is_available()) {
			$query_args["post__in"] = array(0);
			return $query_args;
		}

		$disallowed_products = vcwccr_get_disallowed_products();

		if (!empty($disallowed_products)) {
			$query_args['post__not_in'] = $disallowed_products;
		}

		return $query_args;
	}

}
