<?php

if (!class_exists("VCWCCR_PRODUCT_COUNTRY_RESTRICTIONS")) {

	class VCWCCR_PRODUCT_COUNTRY_RESTRICTIONS {

		private static $instance;

		private function __construct() {
			$this->init();
		}

		public static function get_instance() {
			if (!isset(self::$instance)) {
				$myclass = __CLASS__;
				self::$instance = new $myclass;
			}
			return self::$instance;
		}

		public function __clone() {
			trigger_error("Clonation of this object is forbidden", E_USER_ERROR);
		}

		public function __wakeup() {
			trigger_error("You can't unserealize an instance of " . get_class($this) . " class.");
		}

		function get_files_list($directory_path, $file_format = '.php') {
			$files = glob(trailingslashit($directory_path) . '*' . $file_format);
			return $files;
		}

		public function late_init() {
			// Exit if woocommerce not found
			if (!function_exists('WC')) {
				return;
			}
			require_once plugin_dir_path(__DIR__) . "inc/globals.php";

			// Exit if use can manage shop to let them view all products regardless of country restriction
			if (!is_admin() && current_user_can('manage_woocommerce')) {
				return;
			}

			// Exclude common bots from geolocation by user agent.
			$ua = strtolower(wc_get_user_agent());
			if (strstr($ua, 'bot') || strstr($ua, 'spider') || strstr($ua, 'crawl')) {
				return;
			}

			if (is_admin()) {
				$files = array_merge($this->get_files_list(plugin_dir_path(__DIR__) . "backend/"), $this->get_files_list(plugin_dir_path(__DIR__) . "views/backend/"));
			} else {
				$files = array_merge($this->get_files_list(plugin_dir_path(__DIR__) . "frontend/"));
			}

			foreach ($files as $file_path) {
				require_once $file_path;
			}

			wcacr_set_user_country();
		}

		function set_body_class($classes) {
			$classes[] = 'country-' . wcacr_get_user_country();

			if (is_product()) {
				$classes[] = 'disallowed-country-' . str_replace(',', '-', get_post_meta(get_the_ID(), 'wcacr_disallowed_countries', true));
			}

			return $classes;
		}

		public function init() {
			add_action("plugins_loaded", array($this, "late_init"));
			add_filter('body_class', array($this, "set_body_class"));
		}

	}

}

//Initializing plugin
$vcwccr_plugin = VCWCCR_PRODUCT_COUNTRY_RESTRICTIONS::get_instance();

