<?php
/**
 * Active plugins
 */
if ( ! function_exists( 'get_active_plugins') ){
	function get_active_plugins(){
		$active_plugins = (array) get_option( 'active_plugins', array() );
		if ( is_multisite() ) $active_plugins = array_merge( $active_plugins, get_site_option( 'active_sitewide_plugins', array() ) );
		return $active_plugins;
	}
}

/**
 * WooCommerce Detection
 */
if ( ! function_exists( 'is_woocommerce_active' ) ) {
	function is_woocommerce_active() {
		$active_plugins = get_active_plugins();
		return in_array( 'woocommerce/woocommerce.php', $active_plugins ) || array_key_exists( 'woocommerce/woocommerce.php', $active_plugins );
	}
}

/**
 * WC Vendors Detection
 */
if ( ! function_exists( 'is_wcvendors_active' ) ) {
	function is_wcvendors_active() {
		$active_plugins = get_active_plugins();
		return in_array( 'wc-vendors/class-wc-vendors.php', $active_plugins ) || array_key_exists( 'wc-vendors/class-wc-vendors.php', $active_plugins );
	}
}

/**
*	WC Vendors 2.0.0
*/
if ( ! function_exists( 'is_wcvendors_2_0_0' ) ) {
	function is_wcvendors_2_0_0() {
		if ( class_exists( 'WC_Vendors' ) ){
			return version_compare( WCV_VERSION, '2.0.0', '<');
		}
	}
}


/**
 * WooCommerce Required Notice
 */
if ( ! function_exists( 'woocommerce_required_notice' ) ) {
	function woocommerce_required_notice() {
		echo '<div class="error"><p><strong>' . __( 'WooCommerce not found. WC Vendors Pro requires a minimum of WooCommerce v3.3.0.', 'wcvendors-pro' ) . '</strong></p></div>';
	}
}

/**
 * WCVendors Required Notice
 */
if ( ! function_exists( 'wcvendors_required_notice' ) ) {
	function wcvendors_required_notice() {
		echo '<div class="error"><p><strong>' . __( 'WC Vendors Marketplace not found. WC Vendors Pro requires a minimum of WC Vendors Marketplace v2.0.0', 'wcvendors-pro' ) . '</strong></p></div>';
	}
}


/**
 * WCVendors 2.0.0 Required Notice
 */
if ( ! function_exists( 'wcvendors_2_required_notice' ) ) {
	function wcvendors_2_required_notice() {
		echo '<div class="error"><p>' . __( '<b>WC Vendors Pro requires a minimum of WC Vendors Marketplace v2.0.0', 'wcvendors-pro' ) . '</p></div>';
	}
}


/*
*	Check to see if the current page is a pro dashboard page
*/
if ( ! function_exists( 'wcv_is_dashboard_page' ) ) {
	function wcv_is_dashboard_page( $current_page = 0 ){

		if ( ! $current_page ) $current_page = get_the_ID();
 		if ( ! $current_page ) return false;

 		$dashboard_page_ids = ( array ) get_option( 'wcvendors_dashboard_page_id', array() );
 		if ( empty( $dashboard_page_ids ) ) return false;

 		return in_array( $current_page, $dashboard_page_ids );
 	}
}


if ( ! function_exists( 'wcv_percentage_to_price' ) ) {
	/**
	 * Converts a percentage to a formatted price
	 * @param string $percentage The percentage value
	 * @param float $price 	The actual price
	 * @since 1.5.6
	 */
	function wcv_percentage_to_price( $percentage, $price ) {

		if ( stripos( $percentage, '%' ) > 0 ) {
			$percentage_to_price = wc_price( (float) $price * ( (float) $percentage / 100 ) );
		} else{
			$percentage_to_price =  wc_price( $percentage );
		}
		return $percentage_to_price;
	}
}
