# Sezzle Pay Extension for WooCommerce

## Installation

1. Signup for Sezzle at `https://dashboard.sezzle.com/merchant/signup/`. Login to your dashboard and keep your API Keys page open. You will need it in step `6`.
2. Make sure you have WooCommerce plugin installed.
3. Install the Sezzle Payment plugin and activate.
4. Go to `admin` > `WooCommerce` > `Settings` > `Payments` > `Sezzle`.
5. Fill the form according to the instructions given in the form and save it.
6. Use the gateway address as `https://gateway.sezzle.com/v1`.

### Your store is ready to use Sezzle as a payment gateway.

## Restrict Sezzle based on user roles
Make sure Sezzle Gateway plugin is `active` in Wordpress admin.

#### Hide Sezzle Payment Gateway
If you want to hide Sezzle's payment gateway based on user roles

1. Add the following function to your code:

```php
function restrict_sezzle_pay($available_gateways) {
    unset($available_gateways['sezzlepay']);
    return $available_gateways;
}
```

2. Call the following filter `inside` the user's access deciding code:

```php
add_filter('woocommerce_available_payment_gateways', 'restrict_sezzle_pay');
```

#### Hide Sezzle Product Widget 
If you want to hide Sezzle's product widget based on user's roles

1. Call the following action `inside` the user's access deciding code:

```php
remove_action('woocommerce_single_product_summary', 'add_sezzle_widget_in_product_page');
```

### Example code with `woocommerce-memberships` plugin:

If you are using `woocommerce-memberships` to deal with user roles and restrictions, you can use the following code to hide Sezzle gateway, product and cart widget based on user's role like so:

```php
$user_id = 1;
$plan_id = 42;
$plan = get_post($plan_id);
// If user does not belong to the plan
if(!wc_memberships_is_user_member($user_id, $plan)) {
    // hide the gateway
    add_filter('woocommerce_available_payment_gateways', 'restrict_sezzle_pay'); // make sure restrict_sezzle_pay function is available
    // hide the product widget
    remove_action('woocommerce_single_product_summary', 'add_sezzle_widget_in_product_page');

}
```

### Notes
1. Read about `woocommerce_available_payment_gateways` hook [here](http://hookr.io/filters/woocommerce_available_payment_gateways/).

For more information, please visit [link](https://docs.sezzle.com/#woocommerce).
# Add the following to .gitignore for peace of mind
1. .woocommerce-gateway-sezzle.php
2. .svn