<?php
/**
 * WooCommerce Sezzle Widget Settings
 *
 * @package WC_Gateway_Sezzle
 * @since   2.0.8
 */



if ( !defined('ABSPATH') ) exit;

if ( class_exists( 'WC_Settings_Sezzle_Widget', false ) ) {
    return new WC_Settings_Sezzle_Widget();
}

if ( !class_exists('WC_Settings_Page') ) require_once( WC()->plugin_path() . '/includes/admin/settings/class-wc-settings-page.php' );

class WC_Settings_Sezzle_Widget extends WC_Settings_Page {

    private static $_instance = NULL;
    public static function instance() {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    /**
     * Setup settings class
     *
     * @since  1.0
     */
    public function __construct() {

        $this->id    = 'sezzle_widget';
        $this->label = __( 'Sezzle Widget', 'sezzle-widget' );

        add_filter( 'woocommerce_settings_tabs_array',        array( $this, 'add_settings_page' ), 20 );
        add_action( 'woocommerce_settings_' . $this->id,      array( $this, 'output' ) );
        add_action( 'woocommerce_settings_save_' . $this->id, array( $this, 'save' ) );
        add_action( 'woocommerce_sections_' . $this->id,      array( $this, 'output_sections' ) );
    }


    /**
     * Get sections
     *
     * @return array
     */
    public function get_sections() {

        $sections = array(
            ''         => __( 'Product Page', 'product-page' ),
            'cart_page' => __( 'Cart Page', 'cart-page' )
        );

        return apply_filters( 'woocommerce_get_sections_' . $this->id, $sections );
    }

    /**
     * Get settings array
     *
     * @since 1.0.0
     * @param string $current_section Optional. Defaults to empty string.
     * @return array Array of settings
     */
    public function get_settings( $current_section = '' ) {

        if ( 'cart_page' == $current_section ) {

            /**
             * Filter Plugin Section 2 Settings
             *
             * @since 1.0.0
             * @param array $settings Array of the plugin settings
             */
            $settings = apply_filters( 'sezzle_widget_cart_page_settings', array(


                array(
                    'title' => __( 'Widget Settings for Cart Page', 'woocommerce' ),
                    'type'  => 'title',
                    'desc'  => __( 'Fill up the below information to show Sezzle Widget in Cart Page.', 'woocommerce' ),
                    'id'    => 'widget-cart',
                ),

                array(
                    'name' => __( 'Show Sezzle widget in cart pages', 'woo_sezzlepay' ),
                    'type' => 'checkbox',
                    'desc' => __( 'Show the sezzle widget under price label in cart pages', 'woo_sezzlepay' ),
                    'default' => 'yes',
                    'id' => 'show-cart-page-widget',
                    'desc_tip' => true
                ),

                array(
                    'name' => __( 'Path to element containing price of cart', 'woo_sezzlepay' ),
                    'type' => 'text',
                    'default' => '.amount',
                    'desc' => __( 'Path to the price element to watch for
                            For multiple, separate by |
                            Eg: .product-price/.price|.extra-info/.price-min', 'woo_sezzlepay'
                    ),
                    'id' => 'cart-page-target-path',
                    'desc_tip' => true
                ),

                array(
                    'name' => __( 'Path to where to render the widget to relative to the target', 'woo_sezzlepay' ),
                    'type' => 'text',
                    'default' => '.',
                    'description' => __('Path of the element to which to render widget.
                            For multiple, separate by |
                            This path is relative to the corresponding price element.
                            So, the first path in this will be relative to the first path in Price block selector.
                            Second to the second and so on.
                            Eg: If .product-price/.price is the path to the price element and you want to
                            put the widget in the 2nd parent of that element, you should use ../..', 'woo_sezzlepay'
                    ),
                    'id' => 'cart-page-render-path',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Forcefully show sezzle widget', 'woo_sezzlepay' ),
                    'type' => 'checkbox',
                    'desc' => __( 'Show Sezzle widget even if payment not supported in user\'s country', 'woo_sezzlepay' ),
                    'default' => 'no',
                    'id' => 'cart-page-forced-show',
                    'desc_tip' => true
                ),

                array(
                    'name' => __( 'Widget alignment', 'woo_sezzlepay' ),
                    'type' => 'select',
                    'desc_tip' => __('Alignment of the Sezzle Widget inside the parent element', 'woo_sezzlepay'),
                    'options' => array(
                        'center' => 'Center',
                        'right' => 'Right',
                        'left' => 'Left'
                    ),
                    'class'    => 'wc-enhanced-select',
                    'default' => 'left',
                    'id' => 'cart-page-alignment',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Widget theme', 'woo_sezzlepay'),
                    'type' => 'select',
                    'description' => __('Select the theme depending on your site\'s background', 'woo_sezzlepay'),
                    'options' => array(
                        'light' => 'Light',
                        'dark' => 'Dark'
                    ),
                    'default' => 'light',
                    'id' => 'cart-page-theme',
                    'desc_tip' => true
                ),

                array(
                    'name' => __( 'Widget width Type', 'woo_sezzlepay'),
                    'type' => 'select',
                    'desc' => __('Text width of the widget', 'woo_sezzlepay'),
                    'options' => array(
                        'thin' => 'Thin',
                        'thick' => 'Thick'
                    ),
                    'default' => 'thin',
                    'id' => 'cart-page-width-type',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Widget logo image Url', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Override with URL to a different Logo you want else leave empty', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'cart-page-image-url',
                    'desc_tip' => true
                ),
                array(
                    'name' => __('Hide classes', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Classes to be hidden when sezzle widget is visible.
                        There are other products like Sezzle Pay which do not work in countries where sezzle works.
                        You can hide them by adding their classes here.
                        To hide multiple elements enter their classes like the following.
                        Eg: class-to-hide|class-to-hide-2', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'cart-page-hide-classes',
                    'desc_tip' => true
                ),
                array(
                    'name' => __('Ignored price paths', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Paths to price elements that you want to be ignored.
                        Eg: .product-price/.price|.extra-info/.price-min', 'woo_sezzlepay'),
                    'default' => 'DEL-0',
                    'id' => 'cart-page-ignored-price-paths',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Alignment switch width', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Width in pixels below which alignment will be changed as set in alignment-switch-type', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'cart-page-alignment-switch-min-width',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Widget alignment below alignment-switch-min-width', 'woo_sezzlepay' ),
                    'type' => 'select',
                    'desc' => __('Alignment of the Sezzle Widget inside the parent element below alignment-switch-min-width', 'woo_sezzlepay'),
                    'options' => array(
                        'center' => 'Center',
                        'right' => 'Right',
                        'left' => 'Left'
                    ),
                    'default' => 'left',
                    'id' => 'cart-page-alignment-switch-type',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Max width', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Max width without `px`', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'cart-page-max-width',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Top margin', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Top margin without `px`', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'cart-page-margin-top',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Bottom margin', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Bottom margin without `px`', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'cart-page-margin-bottom',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Font size', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Font size without `px` (all CSS formats)', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'cart-page-font-size',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Font family', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Font family (all CSS formats)', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'cart-page-font-family',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Font Color', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Font Color (all CSS formats)', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'cart-page-color',
                    'desc_tip' => true
                ),

                array(
                    'type' => 'sectionend',
                    'id'   => 'widget-cart',
                ),

            ) );

        } else {

            /**
             * Filter Plugin Section 1 Settings
             *
             * @since 1.0.0
             * @param array $settings Array of the plugin settings
             */
            $settings = apply_filters( 'sezzle_widget_product_page_settings', array(



                array(
                    'title' => __( 'Widget Settings for Product Page', 'woocommerce' ),
                    'type'  => 'title',
                    'desc'  => __( 'Fill up the below information to show Sezzle Widget in Product Page.', 'woocommerce' ),
                    'id'    => 'widget-product',
                ),

                array(
                    'name' => __( 'Show Sezzle widget in product pages', 'woo_sezzlepay' ),
                    'type' => 'checkbox',
                    'desc' => __( 'Show the sezzle widget under price label in product pages', 'woo_sezzlepay' ),
                    'default' => 'yes',
                    'id' => 'show-product-page-widget',
                    'desc_tip' => true
                ),

                array(
                    'name' => __( 'Path to element containing price of product', 'woo_sezzlepay' ),
                    'type' => 'text',
                    'default' => '.price',
                    'desc' => __( 'Path to the price element to watch for
                            For multiple, separate by |
                            Eg: .product-price/.price|.extra-info/.price-min', 'woo_sezzlepay'
                    ),
                    'id' => 'product-page-target-path',
                    'desc_tip' => true
                ),

                array(
                    'name' => __( 'Path to where to render the widget to relative to the target', 'woo_sezzlepay' ),
                    'type' => 'text',
                    'default' => '.',
                    'description' => __('Path of the element to which to render widget.
                            For multiple, separate by |
                            This path is relative to the corresponding price element.
                            So, the first path in this will be relative to the first path in Price block selector.
                            Second to the second and so on.
                            Eg: If .product-price/.price is the path to the price element and you want to
                            put the widget in the 2nd parent of that element, you should use ../..', 'woo_sezzlepay'
                    ),
                    'id' => 'product-page-render-path',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Forcefully show sezzle widget', 'woo_sezzlepay' ),
                    'type' => 'checkbox',
                    'desc' => __( 'Show Sezzle widget even if payment not supported in user\'s country', 'woo_sezzlepay' ),
                    'default' => 'no',
                    'id' => 'product-page-forced-show',
                    'desc_tip' => true
                ),

                array(
                    'name' => __( 'Widget alignment', 'woo_sezzlepay' ),
                    'type' => 'select',
                    'desc_tip' => __('Alignment of the Sezzle Widget inside the parent element', 'woo_sezzlepay'),
                    'options' => array(
                        'center' => 'Center',
                        'right' => 'Right',
                        'left' => 'Left'
                    ),
                    'class'    => 'wc-enhanced-select',
                    'default' => 'left',
                    'id' => 'product-page-alignment',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Widget theme', 'woo_sezzlepay'),
                    'type' => 'select',
                    'description' => __('Select the theme depending on your site\'s background', 'woo_sezzlepay'),
                    'options' => array(
                        'light' => 'Light',
                        'dark' => 'Dark'
                    ),
                    'default' => 'light',
                    'id' => 'product-page-theme',
                    'desc_tip' => true
                ),

                array(
                    'name' => __( 'Widget width Type', 'woo_sezzlepay'),
                    'type' => 'select',
                    'desc' => __('Text width of the widget', 'woo_sezzlepay'),
                    'options' => array(
                        'thin' => 'Thin',
                        'thick' => 'Thick'
                    ),
                    'default' => 'thin',
                    'id' => 'product-page-width-type',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Widget logo image Url', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Override with URL to a different Logo you want else leave empty', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'product-page-image-url',
                    'desc_tip' => true
                ),
                array(
                    'name' => __('Hide classes', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Classes to be hidden when sezzle widget is visible.
                        There are other products like Sezzle Pay which do not work in countries where sezzle works.
                        You can hide them by adding their classes here.
                        To hide multiple elements enter their classes like the following.
                        Eg: class-to-hide|class-to-hide-2', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'product-page-hide-classes',
                    'desc_tip' => true
                ),
                array(
                    'name' => __('Ignored price paths', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Paths to price elements that you want to be ignored.
                        Eg: .product-price/.price|.extra-info/.price-min', 'woo_sezzlepay'),
                    'default' => 'DEL-0',
                    'id' => 'product-page-ignored-price-paths',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Alignment switch width', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Width in pixels below which alignment will be changed as set in alignment-switch-type', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'product-page-alignment-switch-min-width',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Widget alignment below alignment-switch-min-width', 'woo_sezzlepay' ),
                    'type' => 'select',
                    'desc' => __('Alignment of the Sezzle Widget inside the parent element below alignment-switch-min-width', 'woo_sezzlepay'),
                    'options' => array(
                        'center' => 'Center',
                        'right' => 'Right',
                        'left' => 'Left'
                    ),
                    'default' => 'left',
                    'id' => 'product-page-alignment-switch-type',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Max width', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Max width without `px`', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'product-page-max-width',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Top margin', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Top margin without `px`', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'product-page-margin-top',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Bottom margin', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Bottom margin without `px`', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'product-page-margin-bottom',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Font size', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Font size without `px` (all CSS formats)', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'product-page-font-size',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Font family', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Font family (all CSS formats)', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'product-page-font-family',
                    'desc_tip' => true
                ),
                array(
                    'name' => __( 'Font Color', 'woo_sezzlepay'),
                    'type' => 'text',
                    'desc' => __('(Optional) Font Color (all CSS formats)', 'woo_sezzlepay'),
                    'default' => '',
                    'id' => 'product-page-color',
                    'desc_tip' => true
                ),

                array(
                    'type' => 'sectionend',
                    'id'   => 'widget-product',
                ),


            ) );

        }

        /**
         * Filter MyPlugin Settings
         *
         * @since 1.0.0
         * @param array $settings Array of the plugin settings
         */
        return apply_filters( 'woocommerce_get_settings_' . $this->id, $settings, $current_section );

    }


    /**
     * Output the settings
     *
     * @since 1.0
     */
    public function output() {

        global $current_section;

        $settings = $this->get_settings( $current_section );
        WC_Admin_Settings::output_fields( $settings );
    }


    /**
     * Save settings
     *
     * @since 1.0
     */
    public function save() {

        global $current_section;

        $settings = $this->get_settings( $current_section );
        WC_Admin_Settings::save_fields( $settings );
    }
}

return new WC_Settings_Sezzle_Widget();
