<?php
/**
 * The Template for displaying all single Assay posts.
 *
 * @package WordPress
 * @subpackage OneSocial Theme
 * @since OneSocial Theme 1.0.0
 */
get_header();
?>


	<div id="primary" class="site-content default-page">

		<div id="content" role="main">

					
            <article class="page type-page">
                <?php while ( have_posts() ) : the_post(); ?>
                    <h1><?php /* the_title(); */?>Assay Results For:</h1>
                	<div class="assay-product">Product Name:<span>
					<?php   // Get terms for post
						 $terms = get_the_terms( $post->ID , 'product' );
						 // Loop over each item since it's an array
						 if ( $terms != null ){
						 foreach( $terms as $term ) {
						 // Print the name method from $term which is an OBJECT
						 print $term->slug ;
						 // Get rid of the other data stored in the object, since it's not needed
						 unset($term);
					} } ?>
                    </span></div>
    
                <div class="entry-content">
                    
                    <?php if( get_field('lot_number') ): ?>
                        <div class="lot-number">Lot Number: <?php the_field('lot_number'); ?></div>
                    <?php endif; ?>	
                    <?php 
    
                        $file = get_field('assay_printout');
                        
                        if( $file ): 
                        
                            // vars
                            $url = $file['url'];
                            $title = $file['title'];
                            $caption = $file['caption'];
                            
                        
                            // icon
                            $icon = $file['icon'];
                            
                            if( $file['type'] == 'image' ) {
                                
                                $icon =  $file['sizes']['thumbnail'];
                                
                            }
                            
                        
                            if( $caption ): ?>
                        
                                <div class="wp-caption">
                        
                            <?php endif; ?>
                            <div class="assay-download">
                                <a href="<?php echo $url; ?>" title="<?php echo $title; ?>" target="_blank">
                            
                                    <img src="<?php echo $icon; ?>" />
                                    <div class="assay-download"><?php /* echo $title; */?>Download Assay Sheet</div>
                            
                                </a>
                            </div>
                            <?php if( $caption ): ?>
                        
                                    <p class="wp-caption-text"><?php echo $caption; ?></p>
                        
                                </div>
                        
                            <?php endif; ?>
                        
                        <?php endif; ?>
                </div>
                <?php endwhile; // end of the loop. ?>		
            </article>			
		
		</div>
	</div>

    <div id="secondary" class="widget-area" role="complementary">
        <h3>Search Assays</h3>
        <?php echo do_shortcode('[searchandfilter id="1422"]'); ?>    
    </div>

                                	
	</div><!-- #content -->

<?php
get_footer();
