<?php
/*
Plugin Name: Indeed My Team (Visual Composer Version)
Plugin URI: http://www.wpindeed.com/
Description: The best looking and easy to use plugin that helps you to display your team in different showcases
Version: 3.2
Author: indeed
Author URI: http://www.wpindeed.com
*/
if( get_option('imt_post_type_slug')!==FALSE && get_option('imt_post_type_slug')!='' ){
	define('IMT_POST_TYPE_VC', get_option('imt_post_type_slug'));
	if (IMT_POST_TYPE_VC=='team'){
		define('IMT_TAXONOMY_VC', 'team_cats');
	} else {
		define('IMT_TAXONOMY_VC', IMT_POST_TYPE_VC . '_cats');
	}
} else {
	global $wpdb;
	$temp_check = $wpdb->get_var("SELECT COUNT(*) as c FROM {$wpdb->postmeta} WHERE meta_key='in_team_email';");
	if ($temp_check){
		define('IMT_POST_TYPE_VC', 'team');
		define('IMT_TAXONOMY_VC', 'team_cats');	
	} else {
		define('IMT_POST_TYPE_VC', 'imt_team');
		define('IMT_TAXONOMY_VC', 'imt_team_cats');	
	}
	update_option('imt_post_type_slug', IMT_POST_TYPE_VC);
}

define('IMT_DIR_PATH_VC', plugin_dir_path(__FILE__));
define('IMT_DIR_URL_VC', plugin_dir_url(__FILE__));

//LANGUAGES
add_action('init', 'imt_load_language_vc');
function imt_load_language_vc(){
	load_plugin_textdomain( 'imt', false, dirname(plugin_basename(__FILE__)).'/languages/' );
}

///FUNCTIONS
include_once IMT_DIR_PATH_VC.'includes/functions.php';

/////VISUAL COMPOSER
function imt_check_vc(){
    if (function_exists('vc_map')){
      //gettings cats
      $args = array(
                    'taxonomy' => IMT_TAXONOMY_VC,
                    'type' => IMT_POST_TYPE_VC,
					'orderby' => 'slug'
      				);
      $cats = get_categories($args);
      if (isset($cats) && count($cats)>0){
          foreach ($cats as $cat){
                $cat_arr[$cat->slug] = $cat->name;
                $cat_arr_keys[] = $cat->slug;
          }
          $cats_str = implode(',', $cat_arr_keys);
      } else {
            $cat_arr = array();
            $cats_str = '';
      }
        include_once IMT_DIR_PATH_VC.'includes/imt_vc_functions.php';
        vc_map( array(
        			   "name" => __("Indeed My Team", 'imt'),
        			   "base" => "indeed-my-team",
        			   "icon" => "icon-wpb-ttp",
                       "description" => __("Show My Team", 'imt'),
    			       "class" => "indeed-my-team",
    			       "category" => __('Content', "js_composer"),
        			   "params" => array(
        									array(
        										"type" => "imt_select_cats",
        										"heading" => __("Team", 'imt'),
        										"param_name" => "team",
                                                "admin_label" => true,
        										"value" => "all",
        										"description" => "Select one or many Teams with Members"
        									),
        									array(
        										"type" => "imt_number",
        										"heading" => __("Number of items", 'imt'),
        										"param_name" => "limit",
                                                "admin_label" => true,
        										"value" => 10,
        										"param_min_value" => 1,
        										"description" => ""
        									),
											array(
        										  "type" => 'imtvc_sepparate_line',
                                                  "param_name" => "line1",
												  'value' => '',
											),
                                            array(
        										"type" => "imt_custom_dd",
        										"heading" => __("Order By", 'imt'),
                                                "select_id" => "order_by_sel",
                                                "onclick" => "",
        										"param_name" => "order_by",
        										"values" => array("date" => __(" Date", 'imt'), "name" => __("Name", 'imt'), 'last_name'=>__('Last Name', 'imt'), "rand" => __("Random", 'imt') ),
                                                "value" => "name",
        									),
        									array(
        										"type" => "dropdown",
        										"heading" => __("Order Type", 'imt'),
        										"param_name" => "order",
        										"value" => array( __("ASC", 'imt'), __("DESC", 'imt') )
        									),
											array(
        										  "type" => 'imtvc_sepparate_line',
                                                  "param_name" => "line2",
												  'value' => '',
											),
											array(
        										  "type" => 'imtvc_title_block_imtvc_bkcolor6',
        										  "heading" => __("Entry Information", 'imt'),
												  "wrap_div" => TRUE,
                                                  "param_name" => "imt_entry_info",
												  "wrap_class" => "imt_vc_title"
											),
        									array(
        										  "type" => 'imt_checkbox_block',
        										  "heading" => __("Custom Field To Show:", 'imt'),
        										  "hidden_name" => "show",
                                                  "hidden_id" => "hidden_i_cf",
        										  "param_name" => "show",
        										  "checkboxes" => array("name" => __(" Name", 'imt'),
                                                                        "photo" => __(" Photo", 'imt'),
                                                                        "description" => __(" Description", 'imt'),
                                                                        "job" => __(" Job Title", 'imt'),
                                                                        "email" => __(" E-mail", 'imt'),
                                                                        "location" => __(" Location", 'imt'),
                                                                        "tel" => __(" Telephone", 'imt'),
                                                                        "website" => __(" Website", 'imt'),
                                                                        "social_icon" => __(" Social Icons", 'imt'),
                                                                        "skills" => __(" Skills", 'imt')
                                                                        ),
        										  "value" => "name,photo,description,job,social_icon,skills",
        									),
											array(
        										  "type" => 'imtvc_title_block_imtvc_bkcolor1',
        										  "heading" => __("Template", 'imt'),
												  "wrap_div" => TRUE,
                                                  "param_name" => "line3",
												  "wrap_class" => "imt_vc_title"
											),
                                            array(
                                                "type" => "imt_select_themes",
                                                "heading" => __("Select a Theme", 'imt'),
                                                "param_name" => "theme",
                                                "value" => ""
                                            ),
                                            array(
                                                "type" => "imt_color_scheme",
                                                "heading" => __("Select Color Scheme", 'imt'),
                                                "param_name" => "color_scheme",
                                                "value" => "0a9fd8"
                                            ),
											array(
        										  "type" => 'imtvc_sepparate_line',
                                                  "param_name" => "line4",
												  'value' => '',
											),
 											array(
 													"type" => "imt_checkbox_field",
 													"label" => __(" Hide Small Icons", 'imt'),
 													"id_checkbox" => "hide_small_icons",
 													"value" => 0,
 													"id_hidden" => "h_hide_small_icons",
 													"param_name" => "hide_small_icons",
 													"onClick" => "",
 													"text_under" => '<span class="warning_grey_span" style="display:block;">' . __('Available for icons from Email,Website,Telephone fields', 'imt') . '</span>',												
 											), 
				        			   		array(
				        			   				"type" => "imt_checkbox_field",
				        			   				"label" => __(" Align The Items Centered", 'imt'),
				        			   				"id_checkbox" => "align_center",
				        			   				"value" => 0,
				        			   				"id_hidden" => "h_align_center",
				        			   				"param_name" => "align_center",
				        			   				"onClick" => "",
				        			   				"space_under" => 1,
				        			   		),        	
											array(
        										  "type" => 'imtvc_sepparate_line',
                                                  "param_name" => "line5",
												  'value' => '',
											),
                                            array(
        										"type" => "dropdown",
        										"heading" => __("Number of Columns:", 'imt'),
        										"param_name" => "columns",
        										"value" => array(1,2,3,4,5,6),
												"std" => 3
                                            ),
													   		      			   				
                                            /////////////SLIDER
											array(
        										  "type" => 'imtvc_title_block_imtvc_bkcolor2',
        										  "heading" => __("Slider ShowCase", 'imt'),
												  "wrap_div" => TRUE,
												  "wrap_class" => "imtvc_vc_title",
                                                  "param_name" => "line6"
											),
                                            array(
                                                "type" => "imt_checkbox_field_actv",
                                                "label" => __(" Show as Slider", 'imt'),
												"heading" => __("Activate the Slider", 'imt'),
                                                "id_checkbox" => "slider_main_checkbox",
                                                "value" => 0,
                                                "id_hidden" => "show_as_slider",
                                                "param_name" => "slider_set",
                                                "onClick" => "check_mf_selector(this, \".slider_options\", \"opacity\", 1, \"0.5\",\".filter_options\", \"#filter_main_checkbox\",\"#show_as_filter\");",
                                                "slider_or_filter" => "slider",
												"text_under" => "<div class='warning_grey_span'>" . __('If Slider Showcase is used, Filter Showcase is disabled.', 'imt') . "</div>"
                                            ),
        									array(
        										"type" => "imt_number",
                                                "label" => __("Items per Slide:", 'imt'),
        										"param_name" => "items_per_slide",
        										"value" => 3,
        										"param_min_value" => 1,
        										"description" => "",
                                                "wrap_div" => TRUE  ,
                                                "wrap_class" => "slider_options",
                                                "slider_or_filter" => "slider",
        									),
        									array(
        										"type" => "imt_number",
        										"heading" => __("Slide TimeOut", 'imt'),
        										"param_name" => "slide_speed",
        										"value" => 5000,
        										"param_min_value" => 1,
        										"description" => "",
                                                "wrap_div" => TRUE,
                                                "wrap_class" => "slider_options",
                                                "slider_or_filter" => "slider",
        									),
        									array(
        										"type" => "imt_number",
        										"heading" => __("Pagination Speed", 'imt'),
        										"param_name" => "slide_pagination_speed",
        										"value" => 500,
        										"param_min_value" => 1,
        										"description" => "",
                                                "wrap_div" => TRUE,
                                                "wrap_class" => "slider_options",
                                                "slider_or_filter" => "slider",
        									),
											array(
        										  "type" => 'imtvc_sepparate_line',
                                                  "param_name" => "line7",
												  'value' => '',
											),
        									array(
        										  "type" => 'imt_checkbox_block',
        										  "heading" => "Additional Options",
        										  "hidden_name" => "slide_opt",
                                                  "hidden_id" => "hidden_slide_opt",
        										  "param_name" => "slide_opt",
        										  "checkboxes" => array("bullets" => __(" Bullets", 'imt'), "nav_button" => __(" Nav Button", 'imt'), "autoplay" => __(" Autoplay", 'imt'), "stop_hover" => __(" Stop Hover", 'imt'), "responsive" => __(" Responsive", 'imt'),  "autoheight" => __(" Auto Height", 'imt'), "lazy_load" => __(" Lazy Load", 'imt'), "loop"=>__(" Play in Loop", 'imt') ),
        										  "value" => "bullets,nav_button,autoplay,responsive,loop",
                                                  "wrap_div" => TRUE,
                                                  "wrap_class" => "slider_options",
                                                  "slider_or_filter" => "slider",
        									),
											array(
                                                  "type" => "imt_custom_dropdown",
                                                  "label" => __("Pagination Theme", 'imt'),
                                                  "param_name" => "pagination_theme",
                                                  "values" => array("pag-theme1"=>__("Pagination Theme 1", 'imt'), "pag-theme2"=>__("Pagination Theme 2", 'imt'), "pag-theme3"=>__("Pagination Theme 3", 'imt'),),
                                                  "value" => "",
                                                  "wrap_div" => TRUE,
                                                  "wrap_class" => "slider_options",
                                                  "slider_or_filter" => "slider"
                                            ),
											array(
        										  "type" => 'imtvc_sepparate_line',
                                                  "param_name" => "line8",
												  'value' => '',
											),
                                            array(
                                                  "type" => "imt_custom_dropdown",
                                                  "label" => __("Animation Slide In", 'imt'),
                                                  "param_name" => "animation_in",
                                                  "values" => array("none"=>__("None", 'imt'), "fadeIn"=>__("fadeIn", 'imt'), "fadeInDown"=>__("fadeInDown", 'imt'), "fadeInUp"=>__("fadeInUp", 'imt'), "slideInDown"=>__("slideInDown", 'imt'), "slideInUp"=>__("slideInUp", 'imt'), "flip"=>__("flip", 'imt'),
												  					"flipInX"=>__("flipInX", 'imt'),"flipInY"=>__("flipInY", 'imt'),"bounceIn"=>__("bounceIn", 'imt'),"bounceInDown"=>__("bounceInDown", 'imt'),"bounceInUp"=>__("bounceInUp", 'imt'),"rotateIn"=>__("rotateIn", 'imt'),"rotateInDownLeft"=>__("rotateInDownLeft", 'imt'),
																	"rotateInDownRight"=>__("rotateInDownRight", 'imt'),"rollIn"=>__("rollIn", 'imt'),"zoomIn"=>__("zoomIn", 'imt'),"zoomInDown"=>__("zoomInDown", 'imt'),"zoomInUp"=>__("zoomInUp", 'imt')),
                                                  "value" => "",
                                                  "wrap_div" => TRUE,
                                                  "wrap_class" => "slider_options",
                                                  "slider_or_filter" => "slider"
                                            ),
											 array(
                                                  "type" => "imt_custom_dropdown",
                                                  "label" => __("Animation Slide Out", 'imt'),
                                                  "param_name" => "animation_out",
                                                  "values" => array("none"=>__("None", 'imt'), "fadeOut"=>__("fadeOut", 'imt'), "fadeOutDown"=>__("fadeOutDown", 'imt'), "fadeOutUp"=>__("fadeOutUp", 'imt'), "slideOutDown"=>__("slideOutDown", 'imt'), "slideOutUp"=>__("slideOutUp", 'imt'), "flip"=>__("flip", 'imt'),
												  					"flipOutX"=>__("flipOutX", 'imt'),"flipOutY"=>__("flipOutY", 'imt'),"bounceOut"=>__("bounceOut", 'imt'),"bounceOutDown"=>__("bounceOutDown", 'imt'),"bounceOutUp"=>__("bounceOutUp", 'imt'),"rotateOut"=>__("rotateOut", 'imt'),"rotateOutUpLeft"=>__("rotateOutUpLeft", 'imt'),
																	"rotateOutUpRight"=>__("rotateOutUpRight", 'imt'),"rollOut"=>__("rollOut", 'imt'),"zoomOut"=>__("zoomOut", 'imt'),"zoomOutDown"=>__("zoomOutDown", 'imt'),"zoomOutUp"=>__("zoomOutUp", 'imt')),
                                                  "value" => "",
                                                  "wrap_div" => TRUE,
                                                  "wrap_class" => "slider_options",
                                                  "slider_or_filter" => "slider"
                                            ),
                                           
                                            ////////////FILTER
											array(
        										  "type" => 'imtvc_title_block_imtvc_bkcolor3',
        										  "heading" => __("Filter ShowCase", 'imt'),
												  "wrap_div" => TRUE,
												  "wrap_class" => "imtvc_vc_title",
                                                  "param_name" => "line9"
											),
                                            array(
                                                "type" => "imt_checkbox_field_actv",
                                                "label" => __(" Show as Filter", 'imt'),
												"heading" => __("Activate the Filter", 'imt'),
                                                "id_checkbox" => "filter_main_checkbox",
                                                "value" => 0,
                                                "id_hidden" => "show_as_filter",
                                                "param_name" => "filter_set",
                                                "onClick" => "check_mf_selector(this, \".filter_options\", \"opacity\", 1, \"0.5\", \".slider_options\", \"#slider_main_checkbox\", \"#show_as_slider\");",
                                                "slider_or_filter" => "filter",
												"text_under" => "<div class='warning_grey_span'>" . __('If Filter Showcase is used, Slider Showcase is disabled.', 'imt') . "</div>"
                                            ),
											array(
        										  "type" => 'imtvc_sepparate_line',
                                                  "param_name" => "line10",
												  'value' => '',
											),
        									array(
        										  "type" => 'imt_checkbox_block',
        										  "label" => __("Teams", 'imt'),
												  "heading" => __("Teams List", 'imt'),
        										  "hidden_name" => "filter_teams",
                                                  "hidden_id" => "hidden-filterteams",
        										  "param_name" => "filter_teams",
        										  "checkboxes" => $cat_arr,
        										  "value" => '',
                                                  "wrap_div" => TRUE,
                                                  "wrap_class" => "filter_options",
                                                  "slider_or_filter" => "filter",
        									),
											array(
        										  "type" => 'imtvc_sepparate_line',
                                                  "param_name" => "line11",
												  'value' => '',
											),
                                            array(
                                                  "type" => "imt_custom_dropdown",
                                                  "heading" => __("Theme", 'imt'),
                                                  "param_name" => "filter_select_t",
                                                  "values" => array('small_text' => __('Small Text', 'imt'), 'big_text' => __('Big Text', 'imt'), 'small_button' => __('Small Button', 'imt'),'big_button' => __('Big Buttons', 'imt'),'dropdown'=> __('Drop Down', 'imt') ),
                                                  "value" => "",
                                                  "wrap_div" => TRUE,
                                                  "wrap_class" => "filter_options" ,
                                                  "slider_or_filter" => "filter",
                                            ),
                                            array(
                                                  "type" => "imt_custom_dropdown",
                                                  "heading" => __("Align", 'imt'),
                                                  "param_name" => "filter_align",
                                                  "values" => array('left' => __('Left', 'imt'),'center' => __('Center', 'imt'),'right' => __('Right', 'imt') ),
                                                  "value" => "",
                                                  "wrap_div" => TRUE,
                                                  "wrap_class" => "filter_options",
                                                  "slider_or_filter" => "filter",
                                            ),
				        			   		array(
				        			   				"type" => "imt_custom_dropdown",
				        			   				"heading" => __("Layout Mode", 'imt'),
				        			   				"param_name" => "layout_mode",
				        			   				"values" => array('masonry' => __('masonry', 'imt'),'fitRows' => __('fitRows', 'imt') ),
				        			   				"value" => "",
				        			   				"wrap_div" => TRUE,
				        			   				"wrap_class" => "filter_options",
				        			   				"slider_or_filter" => "filter",
				        			   		),        			   		
		   		
                                            //////////end of filter
                                            array(
        										  "type" => 'imtvc_title_block_imtvc_bkcolor5',
        										  "heading" => __("Member Link", 'imt'),
												  "wrap_div" => TRUE,
												  "wrap_class" => "imtvc_vc_title",
                                                  "param_name" => "line12"
											),
											array(
                                                  "type" => "imt_checkbox_field",
                                                  "label" => __(" Activate Inside Page", 'imt'),
                                                  "id_checkbox" => "page_inside_c",
                                                  "value" => 0,
                                                  "id_hidden" => "page_inside",
                                                  "param_name" => "page_inside",
                                                  "onClick" => 'imt_uncheck_c_hz(this, "#tm_custom_href_c", "#tm_custom_href");',
                                            ),      			   		
                                            array(
                                                  "type" => "imt_inside_template",
                                                  "param_name" => "inside_template",
                                                  "value" => "",
                                                  "heading" => "Template"
                                            ),
											array(
        										  "type" => 'imtvc_sepparate_line',
                                                  "param_name" => "line15",
												  'value' => '',
											),
				        			   		array(
				        			   				"type" => "imt_checkbox_field",
				        			   				"label" => __(" Activate Custom Link", 'imt'),
				        			   				"id_checkbox" => "tm_custom_href_c",
				        			   				"value" => 0,
				        			   				"id_hidden" => "tm_custom_href",
				        			   				"param_name" => "tm_custom_href",
				        			   				"onClick" => 'imt_uncheck_c_hz(this, "#page_inside_c", "#page_inside");',
				        			   		),
											array(
        										  "type" => 'imtvc_sepparate_line',
                                                  "param_name" => "line13"
											)
        								)
        			)
        );
        
        $pages = get_pages();
        foreach ($pages as $page){
        	$landing_pages[$page->ID] = $page->post_title;
        }
        
        //SEARCH
        vc_map( array(
        		"name" => __("Indeed My Team - Search", 'imt'),
        		"base" => "imt-search-form-vc",
        		"icon" => "icon-wpb-ttp",
        		"description" => __("Search for a team member", 'imt'),
        		"class" => "imt-search-form-vc",
        		"category" => __('Content', "js_composer"),
        		"params" => array(
			        				array(
			        						"type" => "imt_checkbox_field",
			        						"heading" => __("Show Search Name", 'imt'),
			        						"label" => '',
			        						"id_checkbox" => "c_show_name",
			        						"value" => 1,
			        						"id_hidden" => "h_show_name",
			        						"param_name" => "search_name_on",
			        						"onClick" => "",
			        						"space_under" => 1,
			        				),
			        				array(
			        						"type" => "imt_checkbox_field",
			        						"heading" => __("Show Search Team", 'imt'),
			        						"label" => '',
			        						"id_checkbox" => "c_show_team",
			        						"value" => 1,
			        						"id_hidden" => "h_show_team",
			        						"param_name" => "search_cat_on",
			        						"onClick" => "",
			        						"space_under" => 1,
			        				),
			        				array(
			        						"type" => "textfield",
			        						"heading" => __("Label For Name", 'imt'),
			        						"label" => '',
			        						"param_name" => "search_name",
			        						"value" => 'Name',
			        				),
			        				array(
			        						"type" => "textfield",
			        						"heading" => __("Label For Team", 'imt'),
			        						"label" => '',
			        						"param_name" => "search_cat",
			        						"value" => 'Team',
			        				),
			        				array(
			        						"type" => "textfield",
			        						"heading" => __("Label For Search Button", 'imt'),
			        						"label" => '',
			        						"param_name" => "search_bttn",
			        						"value" => 'Search',
			        				),       
			        				array(
			        						"type" => "imt_custom_dropdown",
			        						"label" => __("Template", 'imt'),
			        						"param_name" => "search_template",
			        						"values" => array("imt-search-form-1" => __("Template 1", 'imt'), 'imt-search-form-2' => __("Template 2", 'imt')),
			        						"value" => "",
			        				),
			        				array(
			        						"type" => "imt_custom_dropdown",
			        						"label" => __("Landing Page", 'imt'),
			        						"param_name" => "landing_page",
			        						"values" => $landing_pages,
			        						"value" => "",
			        				),
        		)
        	)
        );
        
        add_action("admin_enqueue_scripts", 'tp_admin_header');
        function tp_admin_header(){
            wp_enqueue_style( 'imt_style_vc', IMT_DIR_URL_VC . 'files/css/style.css', array(), null );
            wp_enqueue_script( 'imt_js_functions_vc', IMT_DIR_URL_VC.'files/js/functions.js', array(), null );
        }
    }
}
add_action( 'init', 'imt_check_vc' );
add_action( 'init', 'imt_post_team_vc' );
function imt_post_team_vc() {
  $labels = array(
    'name'               => __('Members', 'imt'),
    'singular_name'      => __('Team', 'imt'),
    'add_new'            => __('Add New Member', 'imt'),
    'add_new_item'       => __('Add New Member', 'imt'),
    'edit_item'          => __('Edit Member', 'imt'),
    'new_item'           => __('New Member', 'imt'),
    'all_items'          => __('All Members', 'imt'),
    'view_item'          => __('View Member', 'imt'),
    'search_items'       => __('Search Team Member', 'imt'),
    'not_found'          => __('No Team Members available', 'imt'),
    'not_found_in_trash' => __('No Team Members found in Trash', 'imt'),
    'parent_item_colon'  => '',
    'menu_name'          => __('Team Members', 'imt')
  );
  $args = array(
    'labels'             => $labels,
    'public'             => true,
    'publicly_queryable' => true,
    'show_ui'            => true,
    'show_in_menu'       => true,
    'query_var'          => true,
    'capability_type'    => 'post',
    'has_archive'        => true,
    'hierarchical'       => false,
    'menu_position'      => 8,
    'menu_icon'          => IMT_DIR_URL_VC . 'files/images/ed-gray.png',
    'supports'           => array( 'title', 'editor', 'thumbnail' )
  );
    register_post_type( IMT_POST_TYPE_VC, $args );
}
////////////TAXONOMY
add_action( 'init', 'imt_taxonomy_team_vc', 0 );
function imt_taxonomy_team_vc() {
	$labels = array(
		'name'              => _x( 'Teams', 'taxonomy general name' ),
		'singular_name'     => _x( 'Team', 'taxonomy singular name' ),
		'search_items'      => __( 'Search Teams', 'imt' ),
		'all_items'         => __( 'All Teams', 'imt' ),
		'parent_item'       => __( 'Parent Category', 'imt' ),
		'parent_item_colon' => __( 'Parent Category:', 'imt' ),
		'edit_item'         => __( 'Edit Team', 'imt' ),
		'update_item'       => __( 'Update Category', 'imt' ),
		'add_new_item'      => __( 'Add New Team', 'imt' ),
		'new_item_name'     => __( 'New Category Name', 'imt' ),
		'menu_name'         => __( 'Teams', 'imt' ),
	);
	$args = array(
		'hierarchical'      => true,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => IMT_TAXONOMY_VC ),
	);
register_taxonomy( IMT_TAXONOMY_VC, IMT_POST_TYPE_VC, $args );
}

#Enable feature image for IMT_POST_TYPE
add_action( 'init', 'imt_theme_suport_vc');
function imt_theme_suport_vc(){
	$postTypes = get_theme_support( 'post-thumbnails' );
	if(isset($postTypes) && is_array($postTypes)){
		$postTypes[] = IMT_POST_TYPE_VC;
		add_theme_support( 'post-thumbnails', $postTypes );
	}else{
		add_theme_support( 'post-thumbnails' );
	}
}

/************************ META BOXES *************************/
    add_action( 'add_meta_boxes', 'imt_cf_ti_vc' );
    function imt_cf_ti_vc(){
        add_meta_box('team_personal_info',
                     __('Personal Information', 'imt'),
                     'imt_metabox_ti_vc', //function available in function.php
                     IMT_POST_TYPE_VC,
                     'normal',
                     'high');
    }
    ////////SOCIAL MEDIA
    add_action( 'add_meta_boxes', 'imt_cf_tsm_vc' );
    function imt_cf_tsm_vc(){
        add_meta_box('indeed_team_sm',
                     __('Social Media', 'imt'),
                     'imt_metabox_tsm_vc', //function available in function.php
                     IMT_POST_TYPE_VC,
                     'normal',
                     'high');
    }
    /////////TEAM SKILLS
    add_action( 'add_meta_boxes', 'imt_cf_ts_vc' );
    function imt_cf_ts_vc(){
        add_meta_box('indeed_team_skills',
                     __('Skills', 'imt'),
                     'imt_metabox_ts_vc', //function available in function.php
                     IMT_POST_TYPE_VC,
                     'normal',
                     'low');
    }  
	/////////FEATURE IMAGE
	add_action( 'add_meta_boxes', 'imt_cf_mp_vc' );
    function imt_cf_mp_vc(){
		remove_meta_box( 'postimagediv', 'team', 'side' );
        add_meta_box('postimagediv',
                     __('Member Picture', 'imt'),
                     'post_thumbnail_meta_box',
                     IMT_POST_TYPE_VC,
                     'side',
                     'high');
    }
    #SELECT AUTHOR
    add_action( 'add_meta_boxes', 'imt_select_author_vc' );
    function imt_select_author_vc(){
    	add_meta_box('postexcerpt',
    			__('Select Author', 'imt'),
    			'imtSelectAuthorMetaBox_vc',
    			IMT_POST_TYPE_VC,
    			'normal',
    			'high');
    }
    #CUSTOM LINK
    add_action( 'add_meta_boxes', 'imt_custom_href_vc' );
    function imt_custom_href_vc(){
    	add_meta_box('postcustomhref',
    			__( 'Select Target Link', 'imt'),
    			'imtCustomHrefMetaBox_vc',
    			IMT_POST_TYPE_VC,
    			'normal',
    			'high' );
    }    
    add_action('save_post', 'imt_save_post_meta_values_vc');
/************************ END OF META BOXES *************************/
        
////////SHORTCODE
add_shortcode( 'indeed-my-team', 'imt_shortcode_func_team_vc' );
function imt_shortcode_func_team_vc($attr){
    $return_str = true;
    include IMT_DIR_PATH_VC.'includes/imt_view.php';
    return $final_str;
}
add_action( 'admin_menu', 'imt_shortcode_menu_team_vc' );
function imt_shortcode_menu_team_vc(){
	add_submenu_page( 'edit.php?post_type='.IMT_POST_TYPE_VC, __('General Settings', 'imt'), __('General Settings', 'imt'), 'manage_options', 'imt_general_settings_vc', 'imt_general_settings_vc' );
	
}

$ext_menu = 'edit.php?post_type=' . IMT_POST_TYPE_VC;	
include_once plugin_dir_path(__FILE__) . 'extensions_plus/index.php';

function imt_general_settings_vc(){
	include_once IMT_DIR_PATH_VC .'includes/general_settings.php';
}

////STYLE AND JS
add_action('wp_enqueue_scripts', 'imt_fe_head_vc');
function imt_fe_head_vc(){
  wp_enqueue_style ( 'imt_font-awesome_vc', IMT_DIR_URL_VC.'files/css/font-awesome.min.css' );
  wp_enqueue_style( 'imt_be_style_vc', IMT_DIR_URL_VC.'files/css/style.css' );
  wp_enqueue_style ( 'imt_owl_carousel_vc', IMT_DIR_URL_VC.'files/css/owl.carousel.css' );
  wp_enqueue_script( 'jquery' );
  wp_enqueue_script( 'imt_owl_carousel_vc', IMT_DIR_URL_VC.'files/js/owl.carousel.js', array(), null );
  wp_enqueue_script ( 'imt_isotope_pkgd_min_vc', IMT_DIR_URL_VC.'files/js/isotope.pkgd.min.js', array(), null );
}
add_action("admin_enqueue_scripts", 'imt_be_head_vc');
function imt_be_head_vc(){
	$screen = get_current_screen();
    if( isset($screen->post_type) && $screen->post_type==IMT_POST_TYPE_VC){
          wp_enqueue_style ( 'imt_font-awesome_vc', IMT_DIR_URL_VC.'files/css/font-awesome.min.css' );
          wp_enqueue_style ( 'imt_style_vc', IMT_DIR_URL_VC.'files/css/style.css' );
          wp_enqueue_style ( 'imt_owl_carousel_vc', IMT_DIR_URL_VC.'files/css/owl.carousel.css' );
          wp_enqueue_script( 'jquery' );
          wp_enqueue_script ( 'imt_functions_vc', IMT_DIR_URL_VC.'files/js/functions.js', array(), null );
          wp_enqueue_script ( 'imt_owl_carousel_vc', IMT_DIR_URL_VC.'files/js/owl.carousel.js', array(), null );
    }
}
//////
add_filter( 'template_include', 'itm_portfolio_page_template_vc', 99 );
function itm_portfolio_page_template_vc( $template ) {
    if (get_post_type()==IMT_POST_TYPE_VC && isset($_REQUEST['team_cpt']) && $_REQUEST['team_cpt']!=''){
    	if($_REQUEST['team_cpt']=='IMT_PAGE_TEMPLATE'){
    		//return our awesome page template
    		return IMT_DIR_PATH_VC.'includes/imt_page_template.php';
    	}
        $template = urldecode($_REQUEST['team_cpt']);
        $template .= ".php";
    	$new_template = locate_template( $template );
        return $new_template;
    }
    else return $template;
}

///Ajax change post type name
function imt_change_post_type_vc(){
	if(isset($_REQUEST['post_name']) && $_REQUEST['post_name']!=''){
		if(get_option('imt_post_type_slug')!==FALSE) update_option('imt_post_type_slug', $_REQUEST['post_name']);
		else add_option('imt_post_type_slug', $_REQUEST['post_name']);
		echo $_REQUEST['post_name'];
	}
	die();
}
add_action('wp_ajax_imt_change_post_type_vc', 'imt_change_post_type_vc');
add_action('wp_ajax_nopriv_imt_change_post_type_vc', 'imt_change_post_type_vc');

///All custom post type admin dashboard
add_filter('manage_edit-'.IMT_POST_TYPE_VC.'_columns', 'imt_image_admin_column_vc');
function imt_image_admin_column_vc($columns) {
	$new_columns['cb'] = '<input type="checkbox" />';
	$new_columns['title'] = __('Member Name', 'imt');
	$new_columns['postimagediv'] = __('Member Picture', 'imt');
	$new_columns['taxonomy-'.IMT_TAXONOMY_VC] = __('Teams', 'imt');
	$new_columns['date'] = _x('Date', 'column name');
	return $new_columns;
}

add_action('manage_posts_custom_column',  'imt_display_columns_vc' );
function imt_display_columns_vc($name) {
	global $post;
	$screen = get_current_screen();
	if($screen->post_type==IMT_POST_TYPE_VC){
		switch($name){
			case 'postimagediv':
				if( is_plugin_active('indeed-my-team/indeed-my-team.php') ) return;
				$src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'thumbnail', false, '' );
				if($src!='') echo "<img src='{$src[0]}' width='50' height='50' title='{$post->post_title}'/>";
				break;
		}
	}
}

//SEARCH
add_shortcode( 'imt-search-form-vc', 'imt_search_team_member_shortcode_vc');
function imt_search_team_member_shortcode_vc($attr){
	//check for defaults
	$defaults = array(
						'search_name_on' => 1,
						'search_cat_on' => 1,
						'search_name' => 'Name',
						'search_cat' => 'Team',
						'search_bttn' => 'Search',
						'search_template' => 'imt-search-form-1',
						'landing_page' => '', 
				);
	foreach ($defaults as $key=>$value){
		if (!isset($attr[$key])){
			$attr[$key] = $value;
		}	
	}
	
	if ((empty($attr['search_name']) && empty($attr['search_cat'])) || (empty($attr['search_name_on']) && empty($attr['search_cat_on']))){
		//in case we don't have either search name field of category select field return empty
		return '';
	}
	$str ='';
	if (isset($attr['landing_page'])){
		$landing_page = get_permalink($attr['landing_page']);
	} else {
		$landing_page = get_permalink();
	}
	$style = get_option('imt_custom_css');
	if ($style){
		$str .= '<style>' . $style . '</style>';
	}
	$str .= '<div class="imt-serach-form-wrapp '.$attr['search_template'].'">';
	$str .= '<form action="'.$landing_page.'" method="post">';
	if (isset($attr['search_name']) && !empty($attr['search_name_on'])){
		$str .= '<div class="imt_search_name_class">';
		$str .= '<input type="text" name="imt_search_name" value="" class="imt_search_name" placeholder="'.$attr['search_name'].'" />';
		$str .= '</div>';
	}
	if (isset($attr['search_cat']) && !empty($attr['search_cat_on'])){
		$args = array(
				'taxonomy' => IMT_TAXONOMY_VC,
				'type' => IMT_POST_TYPE_VC,
		);
		$cats = get_categories($args);
		if ($cats && count($cats) ){
			$str .= '<div class="imt_search_cat_class">';
			$str .= '<select name="imt_search_cat" class="imt_search_cat">';
			$str .= '<option value="">'.$attr['search_cat'].'</option>';
			foreach($cats as $cat){
				$str .= '<option value="'.$cat->slug.'" >'.$cat->name.'</option>';
			}
			$str .= '</select>';
			$str .= '</div>';
		}
	}

	$str .= '<div class="imt_search_submit_class">';
	$str .= '<input type="submit" value="'.$attr['search_bttn'].'" name="imt_search" class="imt_search"/>';
	$str .= '</div>';
	$str .= '<div class="imt_clear"></div>';
	$str .= '</form>';
	$str .= '</div>';
	return $str;
}