<?php
/**
 * BuddyPress - Activity Stream (Single Item)
 *
 * This template is used by activity-loop.php and AJAX functions to show
 * each activity.
 *
 * @package BuddyPress
 * @subpackage bp-legacy
 */
?>

<?php do_action( 'bp_before_activity_entry' ); ?>

<li class="<?php bp_activity_css_class(); ?>" id="activity-<?php bp_activity_id(); ?>">
	<div class="activity-avatar">
		<a href="<?php bp_activity_user_link(); ?>">
			<?php //bp_activity_avatar(); ?>
			<?php bp_activity_avatar( 'type=thumb&width=60&height=60' ); ?>
			<?php
			$member_id = bp_get_activity_user_id();
			echo '<div class="name">' . bp_core_get_user_displayname( $member_id ) . '</div>';
			echo '<div class="nice-name">@' . bp_core_get_username( $member_id ) . '</div>';
			?>
		</a>
	</div>

	<div class="activity-content">

		<div class="activity-header">

			<?php bp_activity_action(); ?>

            <div class="activity-meta">

				<?php if ( bp_get_activity_type() == 'activity_comment' ) : ?>

					<a href="<?php bp_activity_thread_permalink(); ?>" class="button view bp-secondary-action" title="<?php esc_attr_e( 'View Conversation', 'onesocial' ); ?>"><?php _e( 'View Conversation', 'onesocial' ); ?></a>

				<?php endif; ?>

				<?php if ( is_user_logged_in() ) : ?>

					<?php if ( bp_activity_can_comment() ) : ?>

						<a href="<?php bp_activity_comment_link(); ?>" class="bb-icon-reply acomment-reply bp-primary-action" id="acomment-comment-<?php bp_activity_id(); ?>" title="<?php esc_attr_e( 'Reply', 'onesocial' ); ?>"></a>

					<?php endif; ?>

					<?php if ( bp_activity_can_favorite() ) : ?>

						<?php if ( !bp_get_activity_is_favorite() ) : ?>

							<a href="<?php bp_activity_favorite_link(); ?>" class="button fav bp-secondary-action" title="<?php esc_attr_e( 'Mark as Favorite', 'onesocial' ); ?>"></a>

						<?php else : ?>

							<a href="<?php bp_activity_unfavorite_link(); ?>" class="button unfav bp-secondary-action" title="<?php esc_attr_e( 'Remove Favorite', 'onesocial' ); ?>"></a>

						<?php endif; ?>

					<?php endif; ?>

					<?php
					if ( bp_activity_user_can_delete() ) {
						$url	 = bp_get_activity_delete_url();
						$class	 = 'delete-activity';

						// Determine if we're on a single activity page, and customize accordingly.
						if ( bp_is_activity_component() && is_numeric( bp_current_action() ) ) {
							$class = 'delete-activity-single';
						}

						echo '<a href="' . esc_url( $url ) . '" class="button item-button bp-secondary-action ' . $class . ' confirm" rel="nofollow" title="' . __( 'Delete', 'buddypress' ) . '">' . __( 'Delete', 'buddypress' ) . '</a>';
					}
					?>

					<?php do_action( 'bp_activity_entry_meta' ); ?>

				<?php endif; ?>

            </div>

        </div>

		<?php if ( bp_activity_has_content() ) : ?>

			<div class="activity-inner">

				<?php bp_activity_content_body(); ?>

			</div>

		<?php endif; ?>

		<?php do_action( 'bp_activity_entry_content' ); ?>

	</div>

	<?php do_action( 'bp_before_activity_entry_comments' ); ?>

	<?php if ( ( bp_activity_get_comment_count() || bp_activity_can_comment() ) || bp_is_single_activity() ) : ?>

		<div class="activity-comments">

			<?php bp_activity_comments(); ?>

			<?php if ( is_user_logged_in() && bp_activity_can_comment() ) : ?>

				<form action="<?php bp_activity_comment_form_action(); ?>" method="post" id="ac-form-<?php bp_activity_id(); ?>" class="ac-form"<?php bp_activity_comment_form_nojs_display(); ?>>
					<div class="ac-reply-avatar">
						<?php bp_loggedin_user_avatar( 'width=' . BP_AVATAR_THUMB_WIDTH . '&height=' . BP_AVATAR_THUMB_HEIGHT ); ?>
						<span class="bb-comment-author"><?php bp_loggedin_user_fullname(); ?></span>
					</div>

					<div class="ac-reply-content">
						<div class="ac-textarea">
							<textarea id="ac-input-<?php bp_activity_id(); ?>" class="ac-input bp-suggestions" name="ac_input_<?php bp_activity_id(); ?>"></textarea>
						</div>
						<input type="submit" name="ac_form_submit" value="<?php esc_attr_e( 'Post', 'onesocial' ); ?>" /> &nbsp; <a href="#" class="ac-reply-cancel"><?php _e( 'Cancel', 'onesocial' ); ?></a>
						<input type="hidden" name="comment_form_id" value="<?php bp_activity_id(); ?>" />
					</div>

					<?php do_action( 'bp_activity_entry_comments' ); ?>

					<?php wp_nonce_field( 'new_activity_comment', '_wpnonce_new_activity_comment' ); ?>

				</form>

			<?php endif; ?>

		</div>

	<?php endif; ?>

	<?php do_action( 'bp_after_activity_entry_comments' ); ?>

</li>

<?php do_action( 'bp_after_activity_entry' ); ?>