( function ( $ ) {

    var isTouch = !!( 'ontouchstart' in window ),
        TorC = isTouch ? 'touchstart' : 'click';

    $( '#main-nav' ).on( TorC, function ( e ) {
        e.preventDefault();

        var $body = $( 'body' ),
            $page = $( '#main-wrap' ),
            transitionEndNav = 'transitionend webkitTransitionEnd otransitionend MSTransitionEnd';

        $( '#mobile-right-panel' ).css( { 'opacity': 1 } );

        $page.on( transitionEndNav, function () {
            if ( !$( 'body' ).hasClass( 'menu-visible-right' ) ) {
                $( '#mobile-right-panel' ).removeAttr( 'style' );
                $page.off( transitionEndNav );
            }
        } );

        /* When the toggle menu link is clicked, animation starts */
        $body.toggleClass( 'menu-visible-right' );


    } );

    $( '#user-nav' ).on( TorC, function ( e ) {
        e.preventDefault();

        var $body = $( 'body' ),
            $page = $( '#main-wrap' ),
            /* Cross browser support for CSS "transition end" event */
            transitionEndNav = 'transitionend webkitTransitionEnd otransitionend MSTransitionEnd';

        $( '#wpadminbar' ).css( { 'opacity': 1 } );

        $page.on( transitionEndNav, function () {
            if ( !$( 'body' ).hasClass( 'menu-visible-left' ) ) {
                $( '#wpadminbar' ).removeAttr( 'style' );
                $page.off( transitionEndNav );
            }
        } );

        /* When the toggle menu link is clicked, animation starts */
        $body.toggleClass( 'menu-visible-left' );

    } );

    $( document ).on( 'ready', function () {

        $( '.bb-overlay' ).on( 'click', function () {
            if ( $( 'body' ).hasClass( 'menu-visible-right' ) ) {
                $( '#main-nav' ).trigger( TorC );
            }

            if ( $( 'body' ).hasClass( 'menu-visible-left' ) ) {
                $( '#user-nav' ).trigger( TorC );
            }
        } );

    } );

    //Fix - mobile left panel links  to be clicked twice
    jQuery("#wpadminbar.mobile").find("#wp-admin-bar-my-account.menupop.with-avatar a.ab-item").on("click.wp-mobile-hover", function(e) {
        e.stopPropagation();
    });

} )( jQuery );