<?php
/**
 * Single Product Thumbnails
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post, $product, $woocommerce;

$attachment_ids = $product->get_gallery_attachment_ids();

if ( $attachment_ids ) {
	$loop 		= 1;
	$columns 	= apply_filters( 'woocommerce_product_thumbnails_columns', 6 );
	?>
	<div class="thumbnails bm-thumbnails-wrap <?php echo 'columns-' . $columns; ?>" data-hover-effect="<?php echo apply_filters( 'bm_thumb_hover_effect', 'true' ) ?>"><?php

		if ( has_post_thumbnail() ) {
			$image_title 		= esc_attr( get_the_title( get_post_thumbnail_id() ) );
			$image_link  		= wp_get_attachment_image_src( get_post_thumbnail_id() , apply_filters( 'single_product_large_thumbnail_size', 'bm-shop_single' ) )[0];
			$full_image_link	= wp_get_attachment_image_src( get_post_thumbnail_id() , 'full' )[0];
			$image       		= get_the_post_thumbnail( $post->ID, apply_filters( 'bm_single_product_small_thumbnail_size', 'bm-store-archive' ), array(
				'title'	=> $image_title,
				'alt'	=> $image_title
			) );

			printf('<a href="javascript:void(0)" data-ref="%s" itemprop="image" class="woocommerce-main-image" title="%s">%s</a>',
				$image_link,
				$image_title,
				$image);

			/** Fake product gallery photo holder for prettyPhoto js ************************/
			printf('<a href="%s" class="bm-product-gallery-photo zoom" data-rel="prettyPhoto[product-gallery]" data-slick-ref="%s"></a>',
				$full_image_link,
				$image_link);
		} else {

			$placeholder = wc_placeholder_img_src();
			printf( '<a href="javascript:void(0)" data-ref="%s"><img src="%s" alt="%s" /></a>', $placeholder, $placeholder, __( 'Placeholder', 'woocommerce' ) );

		}

		foreach ( $attachment_ids as $attachment_id ) {

			$classes = array();

			if ( $loop == 0 || $loop % $columns == 0 )
				$classes[] = 'first';

			if ( ( $loop + 1 ) % $columns == 0 )
				$classes[] = 'last';

			$image_link 	 = wp_get_attachment_image_src( $attachment_id , apply_filters( 'single_product_large_thumbnail_size', 'bm-shop_single' ) )[0];
			$full_image_link = wp_get_attachment_image_src( $attachment_id , 'full' )[0];

			if ( ! $image_link )
				continue;

			$image_title 	= esc_attr( get_the_title( $attachment_id ) );
			$image_caption 	= esc_attr( get_post_field( 'post_excerpt', $attachment_id ) );

			$image       = wp_get_attachment_image( $attachment_id, apply_filters( 'bm_single_product_small_thumbnail_size', 'bm-store-archive' ), 0, $attr = array(
				'title'	=> $image_title,
				'alt'	=> $image_title
			) );

			$image_class = esc_attr( implode( ' ', $classes ) );

			echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', sprintf( '<a href="javascript:void(0)" data-ref="%s" class="%s" title="%s">%s</a>', $image_link, $image_class, $image_caption, $image ), $attachment_id, $post->ID, $image_class );

			/** Fake product gallery photo holder for prettyPhoto js ************************/
			printf( '<a href="%s" title="%s" class="bm-product-gallery-photo zoom" data-rel="prettyPhoto[product-gallery]" data-slick-ref="%s"></a>', $full_image_link, $image_caption, $image_link );

			$loop++;
		}

	?></div>
	<?php
}
