<?php
/**
 * The template for displaying the store settings form
 *
 * Override this template by copying it to yourtheme/wc-vendors/dashboard/
 *
 * @package    WCVendors_Pro
 * @version    1.1.1
 */
?>

<h3>Settings</h3>

<form method="post" action="" class="wcv-form"> 

<div class="wcv-tabs top" data-prevent-url-change="true">

	<ul class="tabs-nav">
  		<li><a class="tabs-tab" href="#storesettings"><?php _e( 'Store', 'wcvendors-pro'); ?></a></li>
  		<li><a class="tabs-tab" href="#vendorpayment"><?php _e( 'Payment', 'wcvendors-pro'); ?></a></li>
  		<li><a class="tabs-tab" href="#branding"><?php _e( 'Branding', 'wcvendors-pro'); ?></a></li>
  		<?php if (! $shipping_disabled ) : ?><li><a class="tabs-tab" href="#shipping"><?php _e( 'Shipping', 'wcvendors-pro'); ?></a></li><?php endif; ?>
  		<li><a class="tabs-tab" href="#social"><?php _e( 'Social', 'wcvendors-pro'); ?></a></li>
	</ul>
	<!-- Store Settings Form -->
	
	<div class="tabs-content" id="storesettings">

		<!-- Store Name -->
		<?php WCVendors_Pro_Store_Form::store_name( $store_name ); ?>

		<?php do_action( 'wcvendors_settings_after_shop_name' ); ?>

		<!-- Store Description -->
		<label><?php _e( 'Store Description', 'wcvendors-pro'); ?></label>
		<?php WCVendors_Pro_Store_Form::store_description( $store_description ); ?>	
		
		<?php do_action( 'wcvendors_settings_after_shop_description' ); ?>
		<br />

		<!-- Seller Info -->
		<label><?php _e( 'Single product page store description', 'wcvendors-pro'); ?></label>
		<?php WCVendors_Pro_Store_Form::seller_info( ); ?>	
		
		
		<?php do_action( 'wcvendors_settings_after_seller_info' ); ?>

		<br />

		<!-- Store Phone -->
		<?php WCVendors_Pro_Store_Form::store_phone( ); ?>

		<?php WCVendors_Pro_Store_Form::store_address( ); ?>

	</div>

	<div class="tabs-content" id="vendorpayment">
		<!-- Paypal address -->
		<?php do_action( 'wcvendors_settings_before_paypal' ); ?>

		<?php WCVendors_Pro_Store_Form::paypal_address( ); ?>

		<?php do_action( 'wcvendors_settings_after_paypal' ); ?>
	</div>

	<div class="tabs-content" id="branding">
		<h6><?php _e( 'Store Banner', 'wcvendors-pro'); ?></h6>
		<?php WCVendors_Pro_Store_Form::store_banner( ); ?>	

		<!-- Store Icon -->
		<h6><?php _e( 'Store Icon', 'wcvendors-pro'); ?></h6>
		<?php WCVendors_Pro_Store_Form::store_icon( ); ?>	
	</div>

	<div class="tabs-content" id="shipping">

		<?php do_action( 'wcvendors_settings_before_shipping' ); ?>

		<!-- Shipping Rates -->
		<?php WCVendors_Pro_Store_Form::shipping_rates( ); ?>
		
		<?php do_action( 'wcvendors_settings_after_shipping' ); ?>

	</div>

	<div class="tabs-content" id="social">
		<!-- Twitter -->
		<?php WCVendors_Pro_Store_Form::twitter_username( ); ?>
		<!-- Instagram -->
		<?php WCVendors_Pro_Store_Form::instagram_username( ); ?>
		<!-- Facebook -->
		<?php WCVendors_Pro_Store_Form::facebook_url( ); ?>
		<!-- Linked in -->
		<?php WCVendors_Pro_Store_Form::linkedin_url( ); ?>
		<!-- Youtube URL -->
		<?php WCVendors_Pro_Store_Form::youtube_url( ); ?>

		<!-- Google+ URL -->
		<?php WCVendors_Pro_Store_Form::googleplus_url( ); ?>
	</div>

	<!-- </div> -->
		<!-- Submit Button -->
		<!-- DO NOT REMOVE THE FOLLOWING TWO LINES -->
		<?php WCVendors_Pro_Store_Form::form_data(); ?>
		<?php WCVendors_Pro_Store_Form::save_button( __( 'Save Changes', 'wcvendors-pro') ); ?>
</div>
	</form>
