<?php
/**
 * The template for displaying the vendor application form 
 *
 * Override this template by copying it to yourtheme/wc-vendors/front
 *
 * @package    WCVendors_Pro
 * @version    1.0.2
 */
?>
<form method="post" action="" class="wcv-form"> 

	<h3><?php __( 'Vendor Application', 'wcvendors-pro'); ?></h3>

	<div class="wcv-tabs top" data-prevent-url-change="true">
		<ul class="tabs-nav" style="padding:0; margin:0;">
	  		<li><a class="tabs-tab" href="#storesettings"><?php _e( 'General Store Information', 'wcvendors-pro'); ?></a></li>
	  		<li><a class="tabs-tab" href="#payment"><?php _e( 'Payment', 'wcvendors-pro'); ?></a></li>
	  		<li><a class="tabs-tab" href="#social"><?php _e( 'Social', 'wcvendors-pro'); ?></a></li>
		</ul>

		<!-- Store Settings Form -->
		<div class="tabs-content" id="storesettings">

				<!-- Store Name -->
				<?php WCVendors_Pro_Store_Form::store_name( '' ); ?>

				<!-- Store Description -->
				<label><?php _e( 'Store Description', 'wcvendors-pro'); ?></label>
				<?php WCVendors_Pro_Store_Form::store_description( '' ); ?>	
				
				<br />

				<!-- Seller Info -->
				<label><?php _e( 'Single product page store description', 'wcvendors-pro'); ?></label>
				<?php WCVendors_Pro_Store_Form::seller_info( ); ?>	
				

				<br />

				<!-- Store Phone -->
				<?php WCVendors_Pro_Store_Form::store_phone( ); ?>

				<?php WCVendors_Pro_Store_Form::store_address( ); ?>

		</div>

		<div class="tabs-content" id="payment">
			<!-- Paypal address -->
			<?php WCVendors_Pro_Store_Form::paypal_address( ); ?>
		</div>

		<div class="tabs-content" id="social">
			<!-- Twitter -->
			<?php WCVendors_Pro_Store_Form::twitter_username( ); ?>
			<!-- Instagram -->
			<?php WCVendors_Pro_Store_Form::instagram_username( ); ?>
			<!-- Facebook -->
			<?php WCVendors_Pro_Store_Form::facebook_url( ); ?>
			<!-- Linked in -->
			<?php WCVendors_Pro_Store_Form::linkedin_url( ); ?>
			<!-- Youtube URL -->
			<?php WCVendors_Pro_Store_Form::youtube_url( ); ?>

			<!-- Google+ URL -->
			<?php WCVendors_Pro_Store_Form::googleplus_url( ); ?>
		</div>

	</div>
		<!-- Submit Button -->
		<!-- DO NOT REMOVE THE FOLLOWING TWO LINES -->
		<?php WCVendors_Pro_Store_Form::sign_up_form_data(); ?>
		<?php WCVendors_Pro_Store_Form::save_button( __( 'Apply to be Vendor', 'wcvendors-pro') ); ?>

	</form>
