<?php
/**
 * The template for showing the vendor store archive 
 *
 * Override this template by copying it to yourtheme/wc-vendors/store
 *
 * @package    WCVendors_Pro
 * @version    1.0.2
 */

get_header( 'shop' ); ?>

	<?php do_action( 'woocommerce_before_main_content' ); ?>	
	<?php do_action( 'wcv_store_before_main_content' ); ?>
	<?php do_action( 'wcv_store_archive_description' ); ?>

		<?php if ( have_posts() ) : ?>

			<?php  do_action( 'wcv_store_before_shop_loop' ); ?>

				<?php while ( have_posts() ) : the_post(); ?>

					<?php 
						$vendor_id 			= $post->post_author; 
						$store_icon_src 	= wp_get_attachment_image_src( get_post_meta( $post->ID, '_wcv_store_icon_id', true ), array( 150, 150 	) ); 
						$store_icon 		= ''; 
						// see if the array is valid
						if ( is_array( $store_icon_src ) ) { 
							$store_icon 	= '<img src="'. $store_icon_src[0].'" alt="" class="store-icon" style="max-width:100%;" />'; 
						} 

						// Get store details including social, adddresses and phone number 
						$twitter_username 	= get_post_meta( $post->ID , '_wcv_twitter_username', true ); 
						$instagram_username = get_post_meta( $post->ID , '_wcv_instagram_username', true ); 
						$facebook_url 		= get_post_meta( $post->ID , '_wcv_facebook_url', true ); 
						$linkedin_url 		= get_post_meta( $post->ID , '_wcv_linkedin_url', true ); 
						$youtube_url 		= get_post_meta( $post->ID , '_wcv_youtube_url', true ); 
						$googleplus_url 	= get_post_meta( $post->ID , '_wcv_googleplus_url', true ); 
					?>
					<article>
						<a href="<?php the_permalink(); ?>">
							<div class="header-container">

								<div id="banner-wrap">
								   <?php the_post_thumbnail(); ?>

								  	<div id="inner-element">
									   	 <div class="all-100 store-info">
									   		
									   		<h3><?php the_title(); ?></h3>	   		
										   		<?php if ( ! WCVendors_Pro::get_option( 'ratings_management_cap' ) ) { echo WCVendors_Pro_Ratings_Controller::ratings_link( $vendor_id, false ); } ?>
									   	</div>  	
									</div>
								</div>
							</div>
						</a>
					</article>
					<br />
					<hr />

				<?php endwhile; // end of the loop. ?>


			<?php do_action( 'wcv_store_after_shop_loop' ); ?>

		<?php elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) : ?>

			<h3>No Vendor Stores Found</h3>

		<?php endif; ?>


	<?php do_action( 'wcv_store_after_main_content' ); ?>
	<?php do_action( 'woocommerce_after_main_content' ); ?>
	<?php do_action( 'woocommerce_sidebar' ); ?>

<?php get_footer( 'shop' ); ?>
