<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive.
 *
 * Override this template by copying it to yourtheme/woocommerce/archive-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.1.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$product_paged 	= get_query_var( 'product_paged' ) ? get_query_var( 'product_paged' ) : 1; 
$vendorstore	= get_query_var( WCVendors_Pro_Store_Controller::$store_slug ); 
$ratings		= get_query_var( 'ratings' ) ? get_query_var( 'ratings' ) : null; 

get_header( 'shop' ); ?>

<?php do_action( 'woocommerce_before_main_content' ); ?>

		<?php if ( have_posts() ) : ?>

			<?php while ( have_posts() ) : the_post(); ?>
						
			<?php 
			
				$store_id 			= $post->ID; 
				$vendor_id 			= $post->post_author; 

				wc_get_template( 'store-header.php', array( 
							'store_id' 	=> $store_id, 
							'vendor_id' => $vendor_id
					), 'wc-vendors/store/', WCVendors_Pro::get_path() . 'templates/store/' ); 
			?>

			<?php endwhile; // end of the loop. ?>

		<?php endif; ?>

		<?php if ( isset( $ratings ) && $ratings == 'all' ) {  

					if ( ! WCVendors_Pro::get_option( 'ratings_management_cap' ) ) {

						echo '<h3>Customer Ratings</h3>'; 

						//  Vendor Ratings 
						$vendor_feedback = WCVendors_Pro_Ratings_Controller::get_vendor_feedback( $vendor_id ); 

						if ( $vendor_feedback ) { 

							foreach ( $vendor_feedback as $vf ) {

								$customer 		= get_userdata( $vf->customer_id ); 
								$rating 		= $vf->rating; 
								$rating_title 	= $vf->rating_title; 
								$comment 		= $vf->comments;
								$post_date		= date_i18n( get_option( 'date_format' ), strtotime( $vf->postdate ) );  
								$customer_name 	= ucfirst( $customer->display_name ); 
								$product_link	= get_permalink( $vf->product_id );
								$product_title	= get_the_title( $vf->product_id ); 

								wc_get_template( 'store-ratings.php', array( 
									'rating' 		=> $rating, 
									'rating_title' 	=> $rating_title,
									'comment' 		=> $comment, 
									'customer_name' => $customer_name, 
									'post_date' 	=> $post_date, 
									'product_link'	=> $product_link, 
									'product_title'	=> $product_title, 

								), 'wc-vendors/store/', WCVendors_Pro::get_path() . 'templates/store/' );
							}

							
						} else { 

							echo __( 'No ratings have been submitted for this vendor yet.', $this->wcvendors_pro ); 
						}
					} 
				} else { 

					wc_get_template( 'store-products.php', 
								array( 
									'vendor_id' 		=> $vendor_id, 
									'product_paged'		=> $product_paged, 
							), 'wc-vendors/store/', WCVendors_Pro::get_path() . 'templates/store/' ); 
				} 

			?>

	<?php do_action( 'woocommerce_after_main_content' ); ?>
	
	<?php do_action( 'woocommerce_sidebar' ); ?>

<?php get_footer( 'shop' ); ?>
