<?php 
/**
 * The Template for displaying a single store front header
 *
 * Override this template by copying it to yourtheme/wc-vendors/store
 *
 * @package    WCVendors_Pro
 * @version    1.0.2
 */

$store_icon_src 	= wp_get_attachment_image_src( get_post_meta( $store_id, '_wcv_store_icon_id', true ), array( 150, 150 	) ); 
$store_icon 		= ''; 

// see if the array is valid
if ( is_array( $store_icon_src ) ) { 
	$store_icon 	= '<img src="'. $store_icon_src[0].'" alt="" class="store-icon" />'; 
} 

// Get store details including social, adddresses and phone number 
$twitter_username 	= get_post_meta( $store_id , '_wcv_twitter_username', true ); 
$instagram_username = get_post_meta( $store_id , '_wcv_instagram_username', true ); 
$facebook_url 		= get_post_meta( $store_id , '_wcv_facebook_url', true ); 
$linkedin_url 		= get_post_meta( $store_id , '_wcv_linkedin_url', true ); 
$youtube_url 		= get_post_meta( $store_id , '_wcv_youtube_url', true ); 
$googleplus_url 	= get_post_meta( $store_id , '_wcv_googleplus_url', true ); 
$address1 			= get_post_meta( $store_id , '_wcv_store_address1', true ); 
$address2 			= get_post_meta( $store_id , '_wcv_store_address2', true ); 
$city	 			= get_post_meta( $store_id , '_wcv_store_city', true ); 
$state	 			= get_post_meta( $store_id , '_wcv_store_state', true ); 
$phone				= get_post_meta( $store_id , '_wcv_store_phone', true ); 
$store_querycode	= get_post_meta( $store_id , '_wcv_store_postcode', true ); 
$address 			= ($address1 != '') ? $address1 .', ' . $city .', '. $state .', '. $store_querycode : '';   

// This is where you would load your own custom meta fields if you stored any in the settings page for the dashboard

?>

<div class="wcv-header-container">

	<div id="banner-wrap">
	   <?php the_post_thumbnail(); ?>

	  	<div id="inner-element">

	  		<?php if ($store_icon != '') : ?>

	  		<div class="all-33 store-brand">	  
		   		<?php echo $store_icon; ?>
		   		<ul class="social-icons"> 
			   			<?php if ( $facebook_url != '') { ?><li><a href="<?php echo $facebook_url; ?>" target="_blank"><i class="fa fa-facebook-square"></i></a></li><?php } ?>
			   			<?php if ( $instagram_username != '') { ?><li><a href="//instagram.com/<?php echo $instagram_username; ?>" target="_blank"><i class="fa fa-instagram"></i></a></li><?php } ?>
			   			<?php if ( $twitter_username != '') { ?><li><a href="//twitter.com/<?php echo $twitter_username; ?>" target="_blank"><i class="fa fa-twitter-square"></i></a></li><?php } ?>
			   			<?php if ( $googleplus_url != '') { ?><li><a href="<?php echo $googleplus_url; ?>" target="_blank"><i class="fa fa-google-plus-square"></i></a></li><?php } ?>
			   			<?php if ( $youtube_url != '') { ?><li><a href="<?php echo $youtube_url; ?>" target="_blank"><i class="fa fa-youtube-square"></i></a></li><?php } ?>
			   			<?php if ( $linkedin_url != '') { ?><li><a href="<?php echo $linkedin_url; ?>" target="_blank"><i class="fa fa-linkedin-square"></i></a></li><?php } ?>
			   	</ul>
		   	</div>
		   	
		   	<div class="all-66 store-info">
		   		
		   		<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>	   		
			   		<?php if ( ! WCVendors_Pro::get_option( 'ratings_management_cap' ) ) echo WCVendors_Pro_Ratings_Controller::ratings_link( $vendor_id, true ); ?>
			   			
			   		<?php the_excerpt(); ?>
		   	</div>
		   	<?php else: ?>	    

		   	 <div class="all-100 store-info">
		   		
		   		<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>	   		
			   		<?php if ( ! WCVendors_Pro::get_option( 'ratings_management_cap' ) ) echo WCVendors_Pro_Ratings_Controller::ratings_link( $vendor_id, true ); ?>
			   		<ul class="social-icons"> 
			   			<?php if ( $facebook_url != '') { ?><li><a href="<?php echo $facebook_url; ?>" target="_blank"><i class="fa fa-facebook-square"></i></a></li><?php } ?>
			   			<?php if ( $instagram_username != '') { ?><li><a href="//instagram.com/<?php echo $instagram_username; ?>" target="_blank"><i class="fa fa-instagram"></i></a></li><?php } ?>
			   			<?php if ( $twitter_username != '') { ?><li><a href="//twitter.com/<?php echo $twitter_username; ?>" target="_blank"><i class="fa fa-twitter-square"></i></a></li><?php } ?>
			   			<?php if ( $googleplus_url != '') { ?><li><a href="<?php echo $googleplus_url; ?>" target="_blank"><i class="fa fa-google-plus-square"></i></a></li><?php } ?>
			   			<?php if ( $youtube_url != '') { ?><li><a href="<?php echo $youtube_url; ?>" target="_blank"><i class="fa fa-youtube-square"></i></a></li><?php } ?>
			   			<?php if ( $linkedin_url != '') { ?><li><a href="<?php echo $linkedin_url; ?>" target="_blank"><i class="fa fa-linkedin-square"></i></a></li><?php } ?>
			   		</ul>
			   		<?php the_excerpt(); ?>
		   	</div>  	
		   	<?php endif; ?>	
		</div>
	</div>
</div>

<div class="wcv-store-address-container">
	<div class="store-address left"> 
		<?php if ( $address != '' ) {  ?><a href="http://maps.google.com/maps?&q=<?php echo $address; ?>"><address><i class="fa fa-location-arrow"></i><?php echo $address; ?></address></a><?php } ?>
	</div>
	<div class="store-phone right">
		<?php if ($phone != '')  { ?><a href="tel:<?php echo $phone; ?>"><i class="fa fa-phone"></i><?php echo $phone; ?></a><?php } ?>
	</div> 
</div>

	