<?php

final class ITSEC_Hide_Backend_Settings_Page extends ITSEC_Module_Settings_Page {
	public function __construct() {
		$this->id = 'hide-backend';
		$this->title = __( 'Hide Backend', 'better-wp-security' );
		$this->description = __( 'Hide the login page by changing its name and preventing access to wp-login.php and wp-admin.', 'better-wp-security' );
		$this->type = 'advanced';
		
		parent::__construct();
	}
	
	protected function render_description( $form ) {
		
?>
	<p><?php _e( 'Hides the login page (wp-login.php, wp-admin, admin and login) making it harder to find by automated attacks and making it easier for users unfamiliar with the WordPress platform.', 'better-wp-security' ); ?></p>
<?php
		
	}
	
	protected function render_settings( $form ) {
		$settings = $form->get_options();
		$permalink_structure = get_option( 'permalink_structure', false );
		
		if ( empty( $permalink_structure ) && ! is_multisite() ) {
			echo '<div class="itsec-warning-message">';
			printf( __( 'You must change <a href="%s">WordPress permalinks</a> to a setting other than "Plain" in order to use this feature.', 'better-wp-security' ), network_admin_url( 'options-permalink.php' ) );
			echo "</div>\n";
			
			return;
		}
		
?>
	<div class="itsec-write-files-disabled">
		<div class="itsec-warning-message"><?php _e( 'The "Write to Files" setting is disabled in Global Settings. In order to use this feature, you must enable the "Write to Files" setting.', 'better-wp-security' ); ?></div>
	</div>
	
	<div class="itsec-write-files-enabled">
		<table class="form-table itsec-settings-section">
			<tr>
				<th scope="row"><label for="itsec-hide-backend-enabled"><?php _e( 'Hide Backend', 'better-wp-security' ); ?></label></th>
				<td>
					<?php $form->add_checkbox( 'enabled', array( 'class' => 'itsec-settings-toggle' ) ); ?>
					<label for="itsec-hide-backend-enabled"><?php _e( 'Enable the hide backend feature.', 'better-wp-security' ); ?></label>
				</td>
			</tr>
		</table>
		
		<table class="form-table itsec-settings-section itsec-hide-backend-enabled-content">
			<tr>
				<th scope="row"><label for="itsec-hide-backend-slug"><?php _e( 'Login Slug', 'better-wp-security' ); ?></label></th>
				<td>
					<?php $form->add_text( 'slug', array( 'class' => 'text code' ) ); ?>
					<br />
					<label for="itsec-hide-backend-slug"><?php printf( __( 'Login URL: %s', 'better-wp-security' ), trailingslashit( get_option( 'siteurl' ) ) . '<span style="color: #4AA02C">' . sanitize_title( $settings['slug'] ) . '</span>' ); ?></label>
					<p class="description"><?php _e( 'The login url slug cannot be "login," "admin," "dashboard," or "wp-login.php" as these are use by default in WordPress.', 'better-wp-security' ); ?></p>
					<p class="description"><em><?php _e( 'Note: The output is limited to alphanumeric characters, underscore (_) and dash (-). Special characters such as "." and "/" are not allowed and will be converted in the same manner as a post title. Please review your selection before logging out.', 'better-wp-security' ); ?></em></p>
				</td>
			</tr>
			<?php if ( get_site_option( 'users_can_register' ) ) : ?>
				<tr>
					<th scope="row"><label for="itsec-hide-backend-register"><?php _e( 'Register Slug', 'better-wp-security' ); ?></label></th>
					<td>
						<?php $form->add_text( 'register', array( 'class' => 'text code' ) ); ?>
						<br />
						<label for="itsec-hide-backend-register"><?php printf( __( 'Registration URL: %s', 'better-wp-security' ), trailingslashit( get_option( 'siteurl' ) ) . '<span style="color: #4AA02C">' . sanitize_title( $settings['register'] ) . '</span>' ); ?></label>
					</td>
				</tr>
			<?php endif; ?>
			<tr>
				<th scope="row"><label for="itsec-hide-backend-theme_compat"><?php _e( 'Enable Redirection', 'better-wp-security' ); ?></label></th>
				<td>
					<?php $form->add_checkbox( 'theme_compat', array( 'class' => 'itsec-settings-toggle' ) ); ?>
					<label for="itsec-hide-backend-theme_compat"><?php _e( 'Redirect users to a custom location on your site, instead of throwing a 403 (forbidden) error.', 'better-wp-security' ); ?></label>
				</td>
			</tr>
			<tr class="itsec-hide-backend-theme_compat-content">
				<th scope="row"><label for="itsec-hide-backend-theme_compat_slug"><?php _e( 'Redirection Slug', 'better-wp-security' ); ?></label></th>
				<td>
					<?php $form->add_text( 'theme_compat_slug', array( 'class' => 'text code' ) ); ?>
					<br />
					<label for="itsec-hide-backend-theme_compat_slug"><?php printf( __( 'Redirect Location: %s', 'better-wp-security' ), trailingslashit( get_option( 'siteurl' ) ) . '<span style="color: #4AA02C">' . sanitize_title( $settings['theme_compat_slug'] ) . '</span>' ); ?></label>
					<p class="description"><?php _e( 'The slug to redirect users to when they attempt to access wp-admin while not logged in.', 'better-wp-security' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row"><label for="itsec-hide-backend-post_logout_slug"><?php _e( 'Custom Login Action', 'better-wp-security' ); ?></label></th>
				<td>
					<?php $form->add_text( 'post_logout_slug', array( 'class' => 'text code' ) ); ?>
					<br />
					<p class="description"><?php _e( 'WordPress uses the "action" variable to handle many login and logout functions. By default this plugin can handle the normal ones but some plugins and themes may utilize a custom action (such as logging out of a private post). If you need a custom action please enter it here.', 'better-wp-security' ); ?></p>
				</td>
			</tr>
		</table>
	</div>
<?php
		
	}
}

new ITSEC_Hide_Backend_Settings_Page();
