<?php
/**
 * This file creates a dummy for the sidebar
 * shown in the media library. Javascript handles
 * it, to append it to the components.
 * 
 * @author MatthiasWeb
 * @package real-media-library
 * @since 1.0
 */

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

$folders = RML_Structure::getInstance();
$folderActive = isset($_REQUEST['rml_folder']) ? $_REQUEST['rml_folder'] : "";
$folderTree = $folders->getView()->treeHTML($folderActive);

// Output extra CSS for the resized sidebar
$cookieWidth = isset($_COOKIE["rml_" . get_current_blog_id() . "_resize"]) ? $_COOKIE["rml_" . get_current_blog_id() . "_resize"] : 0;
if ($cookieWidth > 0 ) {
    echo '<style type="text/css">
body.wp-admin.upload-php #wpbody-content {
    width: calc(100% - ' . $cookieWidth . 'px);
}.rml-container {
    width: ' . $cookieWidth . 'px;
}
</style>';
}

// Output the sidebar
?>
<div class="rml-container rml-dummy">
    <div class="wrap ready-mode rml-hide-upload-preview-<?php echo get_option('rml_hide_upload_preview', 0); ?>">
        <div class="rml-split-resize"></div>
        <h1>
            <?php _e('Folders', RML_TD); ?> 
            <a class="page-title-action" data-type="0" data-helper="create-folder" id="rml-add-new-folder"><i class="fa fa-folder-open-o"></i>&nbsp;<i class="fa fa-plus"></i></a>
            <a class="page-title-action" data-type="1" data-helper="create-collection" id="rml-add-new-collection"><i class="mwf-collection"></i>&nbsp;<i class="fa fa-plus"></i>&nbsp;</a>
            <a class="page-title-action" data-type="2" data-helper="create-gallery" id="rml-add-new-gallery"><i class="mwf-gallery"></i>&nbsp;<i class="fa fa-plus"></i>&nbsp;</a>
            <a class="page-title-action" data-type="3" data-helper="do-nothing" id="rml-do-nothing" style="opacity:0!important;"><i class="mwf-gallery"></i>&nbsp;</a>
        </h1>
        
        <?php // Sidebar header
        ?>
        <div class="wp-filter">
            <div class="rml-info">
                <span><?php echo RML_Structure::getInstance()->getCntAttachments(); ?></span> <?php _e('Files', RML_TD); ?><br />
                <span><?php echo count(RML_Structure::getInstance()->getParsed()); ?></span> <?php _e('Folders', RML_TD); ?>
            </div>
        	<div class="filter-items">
        		<div class="view-switch">
        		    <?php do_action('RML/Sidebar/Toolbar'); ?>
                    <a data-helper="refresh" href="javascript:window.rml.library.refresh();" class="view-switch-refresh"><i class="fa fa-refresh"></i></a>
                    <a data-helper="rename" href="#" class="view-switch-rename" id="rml-folder-rename"><i class="fa fa-pencil"></i></a>
                    <a data-helper="delete" href="#" class="view-switch-delete" id="rml-folder-delete"><i class="fa fa-trash-o"></i></a>
                    <a data-helper="edit" href="#" class="view-switch-sort"><i class="fa fa-sort"></i></a>
        		</div>
        	</div>
        	<div class="clear"></div>
        </div>
        
        <?php // Sidebar tooltips for the header items
        ?>
        <div class="page-title-action-helper" data-helper="create-folder">
            <div><?php _e('Click this to create <strong>a new folder</strong>', RML_TD); ?></div>
            <p><?php _e('A folder can contain every type of file or a collection, but no gallery.', RML_TD); ?></p>
        </div>
        <div class="page-title-action-helper" data-helper="create-collection">
            <div><?php _e('Click this to create <strong>a new collection</strong>', RML_TD); ?></div>
            <p><?php _e('A collection can contain no files. But you can create there other collections and <strong>galleries</strong>.', RML_TD); ?></p>
        </div>
        <div class="page-title-action-helper" data-helper="create-gallery">
            <div><?php _e('Click this to create <strong>a new gallery</strong>', RML_TD); ?></div>
            <p><?php _e('A gallery can contain only images. If you want to display a gallery go to a post and have a look at the visual editor buttons.', RML_TD); ?></p>
        </div>
        <?php do_action('RML/Sidebar/ToolbarTips'); ?>
        <div class="page-title-action-helper bar" data-helper="refresh">
            <div><?php _e('Refresh the current view.', RML_TD); ?></div>
        </div>
        <div class="page-title-action-helper bar" data-helper="delete">
            <div><?php _e('Delete selected folder.', RML_TD); ?></div>
        </div>
        <div class="page-title-action-helper bar" data-helper="rename">
            <div><?php _e('Rename selected folder.', RML_TD); ?></div>
        </div>
        <div class="page-title-action-helper bar" data-helper="edit">
            <div><?php _e('Change the hierarchical order.', RML_TD); ?></div>
        </div>
        
        <div class="clear"></div>
        <div class="sort-notice"><?php _e('Change the hierarchical order.'); ?></div>
        <button style="display:none;" class="abort-sort button-secondary"><?php _e('Cancel'); ?></button>
        <button style="display:none;" class="save-sort button-primary"><?php _e('Save'); ?></button>
        <div class="clear" style="margin-top:5px;"></div>
        
        <div class="rml-uploading" style="display:none;"></div>
        
        <?php // Sidebar content: Folder list
        ?>
        <div class="rml-root-list rml-all-list">
            <a id="rml-list-li-all-files" href="<?php echo RML_Structure::getInstance()->getView()->treeHref("", ""); ?>"
                class="<?php echo RML_Structure::getInstance()->getView()->treeActive($folderActive, ""); ?>"
                data-id="">
                    <i class="fa fa-files-o"></i> <?php _e('All Files', RML_TD); ?>
                    <span><?php echo RML_Structure::getInstance()->getCntAttachments(); ?></span>
            </a>
            
            <hr />
            
            <div class="list rml-root-list">
                <?php echo $folderTree; ?>
            </div>
        </div>
        
        <?php
        // Test: the first folder under root has child folders
        //$test = wp_rml_root_childs();
        //echo wp_rml_select_tree("test", null, $test[0]->children);
        ?>
        
        <?php // Sidebar help links and help content
        ?>
        <div id="rml-info-links">
            <a href="#" id="rml-info-link-info">
                <span class="active-show"><i class="fa fa-close"></i> <?php _e('Hide this info', RML_TD); ?></span>
                <span class="active-hide"><i class="fa fa-info"></i> <?php _e('Help', RML_TD); ?></span>
            </a>
             &bull; 
            <a href="http://codecanyon.net/item/wp-real-media-library-organize-your-uploads/13155134" target="_blank">RML Version <?php echo RML_VERSION; ?></a>
            <br />
            <a href="http://justifiedgrid.com/" target="_blank"><?php _e('Tip: Make your photos shine with Justified&nbsp;Image&nbsp;Grid', RML_TD); ?></a>
            <?php do_action('RML/Sidebar/InfoLinks'); ?>
        </div>
        <div id="rml-info">
            <div class="rml-info-image rii1"></div>
            <div class="arrow-down"><i class="fa fa-arrow-down"></i></div>
            <h3><?php _e('What a chaos in your media library?', RML_TD) ?></h3>
            <div class="arrow-down"><i class="fa fa-arrow-down"></i></div>
            
            <div class="rml-intro-view">
                <span class="rml-intro-view-button">
                    <i class="fa fa-folder-open-o"></i>&nbsp;<i class="fa fa-plus"></i>
                </span>
                <div><?php _e('Click this to create <strong>a new folder</strong>', RML_TD); ?></div>
                <p><?php _e('A folder can contain every type of file or a collection, but no gallery.', RML_TD); ?></p>
            </div>
            
            <div class="rml-intro-view">
                <span class="rml-intro-view-button">
                    <i class="mwf-collection"></i>&nbsp;<i class="fa fa-plus"></i>
                </span>
                <div><?php _e('Click this to create <strong>a new collection</strong>', RML_TD); ?></div>
                <p><?php _e('A collection can contain no files. But you can create there other collections and <strong>galleries</strong>.', RML_TD); ?></p>
            </div>
            
            <div class="rml-intro-view">
                <span class="rml-intro-view-button">
                    <i class="mwf-gallery"></i>&nbsp;<i class="fa fa-plus"></i>
                </span>
                <div><?php _e('Click this to create <strong>a new gallery</strong>', RML_TD); ?></div>
                <p><?php _e('A gallery can contain only images. If you want to display a gallery go to a post and have a look at the visual editor buttons.', RML_TD); ?></p>
            </div>
            
            <div class="arrow-down"><i class="fa fa-arrow-down"></i></div>
            <h3><?php _e('Bye bye chaos!', RML_TD) ?></h3>
            <div class="arrow-down"><i class="fa fa-arrow-down"></i></div>
            <div class="rml-info-image rii2"></div>
        </div>
        
        <?php
        if (isset($_GET["rml_test"])) {
            wp_rml_test_showcase();
        }
        ?>
    </div>
</div>