<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

/**
 * Singleton Core Class
 * 
 * Handles all actions and filter. It includes all available
 * Classes that handle the callbacks.
 */
class RML_Core {
    
    private static $me = null;

    private function __construct() {
        
    }

    public function paging() {
        // Register actions
        add_action('init', array($this, 'init'));
        add_action('admin_init', array(RML_Options::getInstance(), 'register_fields'));
        add_action('plugins_loaded', array($this, 'update_db_check') );

        // Others
        register_activation_hook( RML_FILE, 'rml_install' );
    }
    
    public function init() {
        global $shortcode_tags;
        add_shortcode("folder-gallery", $shortcode_tags['gallery']);
        
        // Add our folder shortcode
        RML_Folder_Shortcode::getInstance();
        
        // Actions
        add_action('admin_enqueue_scripts', array(RML_Backend::getInstance(), 'admin_enqueue_scripts') );
        add_action('admin_footer', array(RML_Backend::getInstance(), 'admin_footer'));
        add_action('pre_get_posts', array(RML_Filter::getInstance(), 'pre_get_posts'), 10);
        add_action('wp_ajax_rml_bulk_move', array(RML_Ajax::getInstance(), 'wp_ajax_bulk_move'));
        add_action('wp_ajax_rml_bulk_sort', array(RML_Ajax::getInstance(), 'wp_ajax_bulk_sort'));
        add_action('wp_ajax_rml_folder_count', array(RML_Ajax::getInstance(), 'wp_ajax_folder_count'));
        add_action('wp_ajax_rml_folder_rename', array(RML_Ajax::getInstance(), 'wp_ajax_folder_rename'));
        add_action('wp_ajax_rml_folder_delete', array(RML_Ajax::getInstance(), 'wp_ajax_folder_delete'));
        add_action('wp_ajax_rml_folder_create', array(RML_Ajax::getInstance(), 'wp_ajax_folder_create'));
        add_action('wp_ajax_rml_wipe', array(RML_Ajax::getInstance(), 'wp_ajax_wipe'));
        add_action('wp_ajax_rml_sidebar_resize', array(RML_Ajax::getInstance(), 'wp_ajax_sidebar_resize'));
        add_action('wp_prepare_attachment_for_js', array(RML_Filter::getInstance(), 'wp_prepare_attachment_for_js'), 10, 3);
        add_action('add_attachment', array(RML_Filter::getInstance(), 'add_attachment'));
        add_action('RML/Structure/Rebuild', array(RML_Util::getInstance(), 'structure_rebuild'));
        
        // Filters
        add_filter('attachment_fields_to_edit', array(RML_CustomField::getInstance(), 'attachment_fields_to_edit'), 10, 2);
        add_filter('attachment_fields_to_save', array(RML_CustomField::getInstance(), 'attachment_fields_to_save'), 10 , 2);
        add_filter('restrict_manage_posts', array(RML_Filter::getInstance(), 'restrict_manage_posts'));
        add_filter('media_buttons_context', array(RML_Filter::getInstance(), 'add_media_button') );
        add_filter('shortcode_atts_gallery', array(RML_Folder_Shortcode::getInstance(), 'shortcode_atts_gallery'), 10, 3 );
        add_action('RML/Backend/JS_Localize', array(RML_Util::getInstance(), 'nonces'));
        
        add_thickbox();
    }
    
    /**
     * Include all necessery files and classes
     */
    public function include_all() {
        $pathes = array(
            "inc/attachment/Folder.class.php",
            "inc/attachment/Structure.class.php",
            "inc/attachment/CustomField.class.php",
            "inc/attachment/Filter.class.php",
            "inc/classes/Util.class.php",
            "inc/classes/QueryCount.class.php",
            "inc/classes/Backend.class.php",
            "inc/classes/Options.class.php",
            "inc/classes/View.class.php",
            "inc/classes/Ajax.class.php",
            "inc/classes/FolderShortcode.class.php",
            "inc/others/install.php",
            "inc/api/api.php"
            );
        
        for ($i = 0; $i < count($pathes); $i++) {
            require_once(RML_PATH . '/' . $pathes[$i]);
        }
    }
    
    public function update_db_check() {
        $installed = get_site_option( 'rml_db_version' );
        if ($installed != RML_VERSION) {
            rml_install();
        }
    }

    public function getTableName() {
        global $wpdb;
        return $wpdb->prefix . 'realmedialibrary';
    }
    
    /**
     * Starts the plugin settings
     */
    public static function start() {
        
        $instance = self::getInstance();
        $instance->include_all();
        $instance->paging();
        
    }
    
    public static function print_r($row) {
        echo '<pre>';
        print_r($row);
        echo '</pre>';
    }
    
    public static function getInstance() {
        if (self::$me == null) {
            self::$me = new RML_Core();
        }
        return self::$me;
    }
    
    public static function get_object_vars_from_public($obj) {
        return get_object_vars($obj);
    }
    
}