<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class RML_Util {
	private static $me = null;
	private $nonces = null;
        
    private function __construct() {
            
    }
    
    /**
     * Rebuilds the absolut pathes when changing the structure.
     * 
     * @hooked RML/Structure/Rebuild
     */
    public function structure_rebuild() {
        $structure = RML_Structure::getInstance();
        $structure->resetData();
        
        $tree = $structure->getTree();
        if (is_array($tree) && count($tree) > 0) {
            foreach ($tree as $key => $value) {
                $value->updateThisAndChildrensAbsolutePath();
            }
        }
    }
    
    /**
     * Adds nonces to the backend.
     * 
     * @hooked RML/Backend/LocalizeJS
     */
    public function nonces($arr) {
        if ($this->nonces == null) {
            $this->nonces = array(
                "bulkMove" => wp_create_nonce("rmlAjaxBulkMove"),
                "bulkSort" => wp_create_nonce("rmlAjaxBulkSort"),
                "folderCount" => wp_create_nonce("rmlAjaxFolderCount"),
                "folderRename" => wp_create_nonce("rmlAjaxFolderRename"),
                "folderDelete" => wp_create_nonce("rmlAjaxFolderDelete"),
                "folderCreate" => wp_create_nonce("rmlAjaxFolderCreate"),
                "sidebarResize" => wp_create_nonce("rmlAjaxSidebarResize")
            );
        }
        
        // Add user orientated nonces
        if (current_user_can("manage_options")) {
            $this->nonces["wipe"] = wp_create_nonce("rmlAjaxWipe");
        }
        
        $arr["nonces"] = $this->nonces;
        return $arr;
    }
    
    public static function getInstance() {
        if (self::$me == null) {
                self::$me = new RML_Util();
        }
        return self::$me;
    }
}

?>