<?php
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file displays the contents of a single
	post. It includes the title, content,
	featured image and post meta. A comments
	section is also displayed below the post.
*/
?>
<div <?php post_class( 'layout-post single' ) ?>>

	<h1 class='layout-title'><?php the_title() ?></h1>

	<?php 
		$image = get_field('alternate_featured_image');
		
		if( !empty($image) ): ?>
		
			<img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>" />
	
	<?php elseif( has_post_thumbnail() ) : ?>
		<?php the_post_thumbnail( bsh_get_layout_size( 'mus_large' ) ) ?>
	<?php endif ?>

	<?php if( bsh_get_page_setting( 'metadata', 'show' ) != 'hide' ) : ?>
	<div class='metas primary-links'>

		<span class='meta date'><span class='icon date'></span> <?php the_time( 'F j, Y' ) ?></span>

		<?php if( has_tag() ) : ?>
		 <span class='meta tags'><span class='icon tags'></span> <?php the_tags('', ', ') ?></span>
		<?php endif ?>

		<?php if( has_category() ) : ?>
		 <span class='meta categories'><span class='icon category'></span> <?php the_category(', ') ?></span>
		<?php endif ?>

		<?php if( comments_open() ) : ?>
		<span class='meta comments'>
			<span class='icon comment'></span>
			<a class='primary' href="<?php comments_link(); ?>"><?php echo comments_number( __( '0 comments', THEMENAME ), __( '1 comment', THEMENAME ), __( '% comments', THEMENAME ) ) ?></a>
		</span>
		<?php endif ?>

	</div>
	<?php endif ?>

	<div class="authorPost">
    	by <?php the_author_meta( 'display_name' ); ?>
    </div>
	<div class='content'>
		<?php the_content() ?>
	</div>

	<?php
		ob_start();
		wp_link_pages( array( 'before' => '<div class="single-pagination"> <span class="title">Pages:</span> ', 'after' => ' </div>' ) );
		$pagination = ob_get_clean();
		$pagination = preg_replace( '/ ([0-9]+) /', ' <span class="current">$1</span> ', $pagination );
		echo $pagination;
	?>

	<?php comments_template() ?>

</div>