/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file creates the javascript controls
	needed for the Theme Customizer live
	preview

*/

/***********************************************/
/*              Table of Contents              */
/***********************************************/
/*

	1. Global Declarations

	2. Global Functions
		2.1 Load Sidebar

	3. Theme Option Modifications
		3.1 General Options
		3.2 Header Options
		3.3 Footer Options

*/

/***********************************************/
/*           1. Global Declarations            */
/***********************************************/

/*global wp, mus, stopQuoteRotation, startQuoteRotation */


/***********************************************/
/*             2. Global Functions             */
/***********************************************/

// 2.1. Load Sidebar
function load_sidebar( sidebar ) {
	if( sidebar === '' || typeof sidebar === 'undefined' || sidebar === null ) {
		sidebar = 'mus_default';
	}
	$.ajax({
		url: mus.ajaxurl,
		type: 'post',
		data: {
			action : 'customizer_get_sidebar',
			sidebar: sidebar
		},
		success: function( result ){
			$('#siteSidebar').html( result );
		}
	});

}

/***********************************************/
/*       3. Theme Option Modifications         */
/***********************************************/
( function( $ ) {


	/*********************************/
	/*      3.1  General Options     */
	/*********************************/
	wp.customize( 'body_text_color', function( value ) {
		value.bind( function( newval ) {
			$( 'html, body, p, a, .body-text-color, table tbody tr td' ).not( '#siteHeader a, h1, h2, h3,h4,h5,h6, h1 a, h2 a, h3 a, h4 a, h5 a, h6 a, .primary, .primary-links a, .button, .button a, #launchPlayer' ).css( 'color', newval  );
			$( '.body-text-lighter' ).css( 'background-color', $.xcolor.lighten( newval, 2, 12 )  )

		});
	});

	wp.customize( 'heading_text_color', function( value ) {
		value.bind( function( newval ) {
			$( 'h1,h2,h3,h4,h5,h6, .heading-text-color, h1 a, h2 a, h3 a, h4 a, h5 a, h6 a' ).not( '#siteHeader a, #siteHeader h1, .widget_rss li > a' ).css( 'color', newval  );
		});
	});

	wp.customize( 'primary_color', function( value ) {
		value.bind( function( newval ) {

			$( '.primary, .primary-links a, .widget_calendar a, .content a' ).not('.widget_rss li > a').css( 'color', newval  );
			$( '.primary-background, .layout-event .metas .meta.time, span.wpcf7-not-valid-tip, .wpcf7-response-output,  #siteFooter,  .pagination .page-numbers.current, .layout-event .metas .meta.time, .layout-event-item .metas .meta.time, #launchPlayer' ).css( 'background-color', newval );

			$( '.button, .button.primary' ).css( 'background', newval  );
			$( '.button, .button.primary' ).css( 'border-color', $.xcolor.darken( newval, 2, 12 )  );
			$( '.button, .button.primary' ).css( 'text-shadow', '-1px -1px 0 ' + $.xcolor.darken( newval, 9, 12 )  );


			$( '#headerCallout, span.wpcf7-not-valid-tip, div.wpcf7-response-output, .tabs dd.active, .tabs li.active, ul.accordion > li.active ' ).css( 'border-color', newval  );

			var color = $.xcolor.darken( newval, 0, 0 );
			var rgb = color.getRGB();

			$( '#siteBar' ).css( 'background-color', 'rgba( ' + rgb.r + ', ' + rgb.g + ', ' + rgb.b + ', 0.9)'  );

			var color = $.xcolor.lighten( newval, 1, 12 );
			var rgb = color.getRGB();

			$( '#headerMenu > div > ul ul' ).css( 'background-color', 'rgba( ' + rgb.r + ', ' + rgb.g + ', ' + rgb.b + ', 0.9)'  );

			var color = $.xcolor.lighten( newval, 1, 24 );
			var rgb = color.getRGB();

			$( '#headerMenu li.current_page_item > a, #headerMenu  li.current_page_parent > a, #headerMenu  li.current_page_ancestor > a, #headerMenu  li.current-menu-item > a, #headerMenu  li.current-menu-ancestor > a, #headerMenu  li.current-menu-parent > a, #headerMenu > div > ul li.current_page_item ul, #headerMenu > div > ul li.current-menu-item ul, #headerMenu > div > ul li.current-menu-parent ul, #headerMenu > div > ul li.current-menu-ancestor ul, #headerMenu > div > ul li.current_page_item ul, #headerMenu > div > ul li.current_page_parent ul, #headerMenu > div > ul li.current_page_ancestor ul' ).css( 'background-color', 'rgba( ' + rgb.r + ', ' + rgb.g + ', ' + rgb.b + ', 0.9)'  );


		});
	});

	wp.customize( 'primary_text_color', function( value ) {
		value.bind( function( newval ) {
			$( '.primary-background, .primary-background a, .primary-background h1, .primary-background h2, .primary-background h3, .primary-background h4, .primary-background h5, .primary-background h6, .layout-event .metas .meta.time, .button, .button.primary, span.wpcf7-not-valid-tip, .wpcf7-response-output, #siteFooter, #siteFooter a, #siteFooter h1, #launchPlayer' ).css( 'color', newval  );
		});
	});

	wp.customize( 'site_background_color', function( value ) {
		value.bind( function( newval ) {
			$( 'html' ).css( 'background-color', newval  );
			$( '.layout-event .metas .meta' ).css( 'background-color', $.xcolor.darken( newval, 1, 12 )  )
		});
	});

	wp.customize( 'background_image', function( value ) {
		value.bind( function( newval ) {
			$( 'html' ).css( 'background-image', 'url( ' + newval + ' ) ' );
		});
	});

	wp.customize( 'background_tiling', function( value ) {
		value.bind( function( newval ) {
			$( 'html' ).css( 'background-repeat', newval );
		});
	});


	wp.customize( 'layout', function( value ) {
		value.bind( function( newval ) {
			$( '#siteContent' ).removeAttr('class');
			if( newval === '1col' ) {
				$('#siteContent').attr( 'class', 'twelve columns' );
				$('#siteSidebar').hide();
			}
			else if( newval === '2col_left' ) {
				$('#siteContent').attr( 'class', 'eight columns push-four' );
				if( $( '#siteSidebar' ).length === 0 ) {
					$( '#siteContent' ).after('<div id="siteSidebar">Loading Sidebar...</div>');
					load_sidebar();
				}
				$('#siteSidebar').attr( 'class', 'four columns pull-eight' ).show();
			}
			else {
				$('#siteContent').attr( 'class', 'eight columns' );
				if( $( '#siteSidebar' ).length === 0 ) {
					$( '#siteContent' ).after('<div id="siteSidebar">Loading Sidebar...</div>');
					load_sidebar();
				}
				$('#siteSidebar').attr( 'class', 'four columns' ).show();
			}
		});
	});

	wp.customize( 'sidebar', function( value ) {
		value.bind( function( newval ) {
			load_sidebar( newval );
		});
	});


	wp.customize( 'logo_font_size', function( value ) {
		value.bind( function( newval ) {
			$( '#headerLogo h1' ).css( 'font-size', newval  );
		});
	});

	wp.customize( 'logo_position_top', function( value ) {
		value.bind( function( newval ) {
			$( '#headerLogo img' ).css( 'top', newval  );
		});
	});

	wp.customize( 'logo_position_left', function( value ) {
		value.bind( function( newval ) {
			$( '#headerLogo img' ).css( 'left', newval  );
		});
	});


	wp.customize( 'content_background', function( value ) {
		value.bind( function( newval ) {
			$( '#siteContainer, .line a' ).css( 'background-color', newval  );
			$( '#siteContainer' ).css( 'border-color', $.xcolor.darken( newval, 1, 18 ) );
			$( '.layout-event .metas .meta' ).css( 'background-color', $.xcolor.darken( newval, 1, 12 ) );
			$( '.layout-event .metas .meta, .layout-event-item .metas .meta, .pagination .page-numbers' ).not('.layout-event-item .metas .meta.time').css( 'background-color', $.xcolor.darken( newval, 1, 9 ) );
			$( '.layout-event .map-canvas' ).css( 'border-color', $.xcolor.darken( newval, 1, 12 ) );
			$( 'img, a img, .list-item' ).css( 'border-color', $.xcolor.darken( newval, 2, 12 ) );
			$( '.commentlist .bypostauthor > article, input[type="text"], input[type="password"], input[type="date"], input[type="datetime"], input[type="email"], input[type="number"], input[type="search"], input[type="tel"], input[type="time"], input[type="url"], textarea, .customSelect' ).css( 'background-color', $.xcolor.darken( newval, 1, 6 ) )

		});
	});



	wp.customize( 'audioplayer_background', function( value ) {
		value.bind( function( newval ) {
			$( '.ttw-music-player' ).css( 'background-color', newval  );
		});
	});

	wp.customize( 'header_image', function( value ) {
		value.bind( function( newval ) {
			$( '#headerBackground img' ).attr( 'src',  newval  );
		});
	});

	wp.customize( 'header_callout_text', function( value ) {
		value.bind( function( newval ) {
			$( '#headerCallout' ).html(  newval  );
		});
	});

	wp.customize( 'header_callout_link', function( value ) {
		value.bind( function( newval ) {
			$( '#headerCallout' ).attr( 'onclick', 'window.location="' + newval + '"'  );
		});
	});


	wp.customize( 'logo_image', function( value ) {
		value.bind( function( newval ) {
			if( newval === '' || newval === null || typeof newval === 'undefined' ) {
				$('#headerLogo img').hide();
				$('#headerLogo h1').show();
			}
			else {
				$('#headerLogo img').show();
				$('#headerLogo h1').hide();
				$('#headerLogo img' ).attr( 'src',  newval  );
			}
		});
	});




	wp.customize( 'sidebar_background_color', function( value ) {
		value.bind( function( newval ) {
			$( '#siteSidebar' ).css( 'background-color', newval  );
		});
	});

	wp.customize( 'sidebar_text_color', function( value ) {
		value.bind( function( newval ) {
			$( '#siteSidebar, #siteSidebar abbr, #siteSidebar acronym' ).css( 'color', newval  );
		});
	});

	wp.customize( 'sidebar_heading_color', function( value ) {
		value.bind( function( newval ) {
			$( '#siteSidebar h1,#siteSidebar h2,#siteSidebar h3,#siteSidebar h4,#siteSidebar h5,#siteSidebar h6' ).css( 'color', newval  );
		});
	});


	wp.customize( 'albumplayer_launch_text', function( value ) {
		value.bind( function( newval ) {
			$( '#launchPlayer' ).html( newval );
			$( '#launchPlayerLink' ).html( newval );
			$( '#launchPlayer' ).attr( 'data-open_text', newval )
		});
	});

	wp.customize( 'albumplayer_close_text', function( value ) {
		value.bind( function( newval ) {
			$( '#launchPlayer' ).attr( 'data-close_text', newval )
		});
	});


	wp.customize( 'sidebar_link_color', function( value ) {
		value.bind( function( newval ) {
			$( '#siteSidebar a' ).css( 'color', newval  );
		});
	});




} )( jQuery );