<?php
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file generates the options needed for
	the blog page template.
*/

/***********************************************/
/*              Table of Contents              */
/***********************************************/
/*

	1. Default Page Options Class
		1.1 Constructor
		1.2 Options Box Content

	2. Instantiating The Options

*/

/***********************************************/
/*       1. Default Page Options Class         */
/***********************************************/

class bshListPageOptions extends bshOptions {

	// 1.1 Constructor
	function __construct() {
		$args = array(
			'title'     => __( 'List Page Options', THEMENAME ),
			'post_type' => 'page',
			'template'  => 'template-bshListPage.php',
			'context'   => 'normal',
			'priority'  => 'high'
		);
        parent::__construct( $args );
        $this->setup_options();
	}

	// 1.2 Options Box Content
    public function options_box_content( $post ) {
        ?>
        	<div id='bshLogo'></div>
        	<div id='optionsContainer'>
        		<div id='menuBackground'></div>
	        	<ul id='bshMenu'>
	        		<li class='active'><?php _e( 'Structure', THEMENAME ) ?></li>
	        		<li><?php _e( 'List Page Options', THEMENAME ) ?></li>
	        		<li><?php _e( 'Help', THEMENAME) ?></l1>
	        		<li><?php _e( 'Shortcode Guide', THEMENAME) ?></l1>
	        		<li><?php _e( 'Get Support', THEMENAME) ?></l1>
	        	</ul>
	        	<div id='bshOptions'>
		        	<input id='bshSaveTop' name="save" type="submit" class="button button-primary button-large" id="publish" accesskey="p" value="Update">

	        		<section class='active'>
	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php echo sprintf( __( 'By default the layout of this page is inherited from the default layout which can be changed in the <a href="%s">Theme Customizer</a>. If you need a different layout on this page, you can override the default setting.', THEMENAME ), esc_url( admin_url( 'customize.php' ) ) ) ?>
        						</div>
        					</div>

	        				<label for='_mus_layout' class='sectionTitle'><?php _e( 'Layout', THEMENAME ) ?></label>
	        				<?php
	        					$choices = array(
	        						'Global Setting' => 'default',
	        						'2 Columns - Sidebar on the Right' => '2col_right',
	        						'2 Columns - Sidebar on the Left'  => '2col_left',
	        						'1 Column' => '1col'
	        					)
	        				?>
	        				<ul class='choices'>
		        				<?php
		        					$current = get_post_meta( $post->ID,  '_mus_layout', true );

		        					$i=1; foreach( $choices as $choice => $value ) :
		        					$checked = ( $current == $value OR ( empty( $current ) AND $value == 'default' ) ) ? 'checked="checked"' : '';
		        				?>
		        				<li>
		        				<input <?php echo $checked ?> type='radio' id='_mus_layout-<?php echo $i ?>' name='_mus_layout' value='<?php echo $value ?>'><label for='_mus_layout-<?php echo $i ?>'><?php echo $choice ?></label><br>
		        				</li>
		        				<?php $i++; endforeach ?>
	        				</ul>
	        			</div>

	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php _e( 'By default the title of this page is shown under the header. If you would like to hide this title, check the radio button next to  "Hide"', THEMENAME ) ?>
        						</div>
        					</div>

	        				<label for='_mus_title' class='sectionTitle'><?php _e( 'Page Title', THEMENAME ) ?></label>
	        				<?php
	        					$choices = array(
	        						'Show' => 'show',
	        						'Hide' => 'hide',
	        					)
	        				?>
	        				<ul class='choices'>
		        				<?php
		        					$current = get_post_meta( $post->ID, '_mus_title', true );
		        					$i=1; foreach( $choices as $choice => $value ) :
		        					$checked = ( $current == $value OR ( empty( $current ) AND $value == 'show' ) ) ? 'checked="checked"' : '';
		        				?>
		        				<li>
		        				<input <?php echo $checked ?> type='radio' id='_mus_title-<?php echo $i ?>' name='_mus_title' value='<?php echo $value ?>'><label for='_mus_title-<?php echo $i ?>'><?php echo $choice ?></label><br>
		        				</li>
		        				<?php $i++; endforeach ?>
	        				</ul>
	        			</div>

	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php _e( 'By default the featured image is shown inside the post. You can also select it to be used as the large header image for this page instead.', THEMENAME ) ?>
        						</div>
        					</div>

	        				<label for='_mus_header_image' class='sectionTitle'><?php _e( 'Featured Image Location', THEMENAME ) ?></label>
	        				<?php
	        					$choices = array(
	        						'In Post' => 'post_content',
	        						'Use As Header Image' => 'header',
	        					)
	        				?>
	        				<ul class='choices'>
		        				<?php
		        					$current = get_post_meta( $post->ID, '_mus_header_image', true );
		        					$i=1; foreach( $choices as $choice => $value ) :
		        					$checked = ( $current == $value OR ( empty( $current ) AND $value == 'post_content' ) ) ? 'checked="checked"' : '';
		        				?>
		        				<li>
		        				<input <?php echo $checked ?> type='radio' id='_mus_header_image-<?php echo $i ?>' name='_mus_header_image' value='<?php echo $value ?>'><label for='_mus_header_image-<?php echo $i ?>'><?php echo $choice ?></label><br>
		        				</li>
		        				<?php $i++; endforeach ?>
	        				</ul>
	        			</div>


	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php echo sprintf( __( 'If you are using a layout with a sidebar the default sidebar will be shown. You can set the default sidebar in the <a href="%s">Theme Customizer</a>. If you would like to use a different sidebar on this page, choose one here.', THEMENAME ), esc_url( admin_url( 'customize.php' ) ) ) ?>
        						</div>
        					</div>

	        				<label for='_mus_sidebar' class='sectionTitle'><?php _e( 'Sidebar', THEMENAME ) ?></label>

	        				<?php
		        				$current = get_post_meta( $post->ID,  '_mus_sidebar', true );
								$choices = explode(',', get_theme_mod( 'sidebars' ) );
								$sidebars['default'] = 'Default';
								$sidebars['Sidebar'] = 'Sidebar';
								foreach( $choices as $choice ) {
									$choice = trim( $choice );
									if( !empty( $choice ) ) {
										$sidebars[$choice] = $choice;
									}
								}
	        					$current = get_post_meta( $post->ID, '_mus_sidebar', true );
	        				?>
	        				<select id='_mus_sidebar' name='_mus_sidebar'>
		        				<?php
		        					foreach( $sidebars as $value => $name ) :
		        					$selected = ( $current == $value OR ( empty( $current ) AND $value == 'default' ) ) ? 'selected="selected"' : '';
		        				?>
		        				<option value='<?php echo $value ?>' <?php echo $selected ?>>
		        				<?php echo $name ?>
		        				</option>
		        				<?php endforeach ?>
	        				</select>
	        			</div>
	        		</section>
	        		<section>
	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php _e( 'Type the maximum number of posts to show on each page of this blog page.', THEMENAME ) ?>
        						</div>
        					</div>

        					<?php
        						$current = get_post_meta( $post->ID, '_mus_posts_per_page', true );
        						$current = empty( $current ) ? get_option( 'posts_per_page' ) : $current;
        					?>
	        				<label for='_mus_posts_per_page' class='sectionTitle'><?php _e( 'Posts Per Page', THEMENAME ) ?></label>
		        			<input type='text' id='_bsh_posts_per_page' name='_mus_posts_per_page' value='<?php echo $current ?>'>
	        			</div>

	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php _e( 'Choose the post types to show. If none are chosen, posts will be shown from all post types.', THEMENAME ) ?>
        						</div>
        					</div>

	        				<label for='_mus_post_types' class='sectionTitle'><?php _e( 'Post Types', THEMENAME ) ?></label>

			        			<span class='checkAll'>select all</span>
			        			<span class='checkNone'>select none</span>

			        			<div class='clear'></div>


	        					<?php
	        						$types = array( 'post', 'event', 'album' );
		        				?>
		        				<ul class='choices half-left'>
			        				<?php
			        					$current = get_post_meta( $post->ID,  '_mus_post_types', true );

			        					$i=1; foreach( $types as $type ) :
			        					$checked = ( is_array( $current ) AND in_array( $type, $current ) ) ? 'checked="checked"' : '';
			        				?>
			        				<li>
			        				<input <?php echo $checked ?> type='checkbox' id='_mus_post_types-<?php echo $i ?>' name='_mus_post_types[]' value='<?php echo $type ?>'><label for='_mus_post_types-<?php echo $i ?>'><?php echo ucfirst( $type ) ?></label><br>
			        				</li>
			        				<?php $i++; endforeach ?>
		        				</ul>

		        			<input type='hidden' id='_mus_post_types-<?php echo $i ?>' name='_mus_post_types[]' value='none'>

	        				<div class='clear'></div>

	        			</div>


	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php _e( 'The two selector boxes govern how posts are ordered. In the first box you can select the criteria for ordering the posts (date, title, etc.). In the second box you can choose the direction of the ordering, ascending or descending. ', THEMENAME ) ?>
        						</div>
        					</div>

	        				<label for='_mus_orderby' class='sectionTitle'><?php _e( 'Order Posts By', THEMENAME ) ?></label>

	        				<?php
		        				$choices = array(
		        					'date'          => 'Publication Date',
		        					'comment_count' => 'Comment Count',
		        					'modified'      => 'Modification Date',
		        					'ID'            => 'Post ID'
		        				);
	        					$current = get_post_meta( $post->ID, '_mus_orderby', true );
	        				?>
	        				<select id='_mus_orderby' name='_mus_orderby'>
		        				<?php
		        					foreach( $choices as $value => $name ) :
		        					$selected = ( $current == $value OR ( empty( $current ) AND $value == 'date' ) ) ? 'selected="selected"' : '';
		        				?>
		        				<option value='<?php echo $value ?>' <?php echo $selected ?>>
		        				<?php echo $name ?>
		        				</option>
		        				<?php endforeach ?>
	        				</select>

	        				<?php
		        				$choices = array(
		        					'DESC' => 'Descending',
		        					'ASC'  => 'Ascending',
		        				);
	        					$current = get_post_meta( $post->ID, '_mus_order', true );
	        				?>
	        				<select id='_mus_order' name='_mus_order'>
		        				<?php
		        					foreach( $choices as $value => $name ) :
		        					$selected = ( $current == $value OR ( empty( $current ) AND $value == 'DESC' ) ) ? 'selected="selected"' : '';
		        				?>
		        				<option value='<?php echo $value ?>' <?php echo $selected ?>>
		        				<?php echo $name ?>
		        				</option>
		        				<?php endforeach ?>
	        				</select>

	        			</div>

	        			<div class='option'>
        					<div class='help'>
        						<span class='title'><?php _e( 'help', THEMENAME ) ?></span>
        						<div class='content'>
        						<?php echo _e( 'By Selecting a number of categories you can narrow the post items shown to only those categories. If no categories are selected all posts will be shown, making the page act as a regular blog archive. Categories only apply to the "Post" post type.', THEMENAME ) ?>
        						</div>
        					</div>

	        				<label for='_mus_categories' class='sectionTitle'><?php _e( 'Post Categories to Show', THEMENAME ) ?></label>

	        				<?php
	        					$categories = get_terms( 'category' );
	        					if( empty( $categories ) ) {
	        						_e( 'You haven\'t created any categories yet. You can do so by clicking on any post item (or creating one) and adding a category on the fly using the "Categories" box on the right. You can also click on "Categories" in "Posts" in the left hand menu', THEMENAME );
	        					}
	        					else {

	        					?>

			        				<span class='checkAll'>select all</span>
			        				<span class='checkNone'>select none</span>

			        				<div class='clear'></div>


	        					<?php
		        					$categories_1 = array_slice( $categories, 0, ceil( count( $categories ) / 2 ) );
		        					$categories_2 = array_slice( $categories, ceil( count( $categories ) / 2 ) );
		        				?>
		        				<ul class='choices half-left'>
			        				<?php
			        					$current = get_post_meta( $post->ID,  '_mus_categories', true );

			        					$i=1; foreach( $categories_1 as $category ) :
			        					$checked = ( is_array( $current ) AND in_array( $category->term_id, $current ) ) ? 'checked="checked"' : '';
			        				?>
			        				<li>
			        				<input <?php echo $checked ?> type='checkbox' id='_mus_categories-<?php echo $i ?>' name='_mus_categories[]' value='<?php echo $category->term_id ?>'><label for='_mus_categories-<?php echo $i ?>'><?php echo $category->name ?></label><br>
			        				</li>
			        				<?php $i++; endforeach ?>
		        				</ul>
		        				<ul class='choices half-right'>
			        				<?php

			        					foreach( $categories_2 as $category ) :
			        					$checked = ( is_array( $current ) AND in_array( $category->term_id, $current ) ) ? 'checked="checked"' : '';
			        				?>
			        				<li>
			        				<input <?php echo $checked ?> type='checkbox' id='_mus_categories-<?php echo $i ?>' name='_mus_categories[]' value='<?php echo $category->term_id ?>'><label for='_mus_categories-<?php echo $i ?>'><?php echo $category->name ?></label><br>
			        				</li>
			        				<?php $i++; endforeach ?>
		        				</ul>
		        			<?php } ?>

		        			<input type='hidden' id='_mus_categories-<?php echo $i ?>' name='_mus_categories[]' value='none'>
	        				<div class='clear'></div>

	        			</div>


	        		</section>
	        		<section class='helpSection'>
	        			<?php
	        			_e('

							<p>The list page template allows you to create a blog-like list of the items you want to show. When you upload your theme and start adding items the default behaviour is to have the latest items show up on the front page. In this case albums, events and posts will all be shown. However, you might want to show only upcoming events on the front page and use a dedicated page for albums and blog posts. If this is what you\'re looking for, the list page template is what you need.</p>
							<p>To create a list page first go to the Page section and add a new page. On the right, select \'List Page\' from the template selector. You should see that specific options for this page type are loaded. Once done, you can add a title, some content, and choose your options. List pages allow you to modify the following settings:</p>
							<ul>
							<li>Structure
							<ul>
							<li><span style="line-height: 13px;"><strong>Layout</strong>: Determines the type of layout you would like for this specific page</span></li>
							<li><strong>Page Title</strong>: Allows you to show or hide the page title</li>
							<li><strong>Featured Image Location</strong>: Allows you to user the featured image as the header image</li>
							<li><strong>Sidebar</strong>: Allows you to show a specific sidebar for this page</li>
							</ul>
							</li>
							<li>List Page Options
							<ul>
							<li><strong>Posts Per Page</strong>: Determines the number of items shown on one page</li>
							<li><strong>Post Types</strong>: Select the types of items you would like to show on this list</li>
							<li><strong>Order Posts By</strong>: Allows you to set the ordering scheme</li>
							<li><strong>Post Categories To Show</strong>: Allows you to narrow your posts to categories. Note that this is only applied to the \'post\' post type. Events and albums do not have categories.</li>
							</ul>
							</li>
							</ul>
							<p>Don\'t forget that help is available inline inside the options box. You can read the text of this article there, as well as reading inline help for each specific option next to the option itself. Simply hover over the help link.</p>


	        			', THEMENAME );
	        			?>
	        		</section>
	        		<section class='helpSection'>
	        			<?php echo bsh_docs_shortcodes() ?>
		        	</section>
		        	<section class='helpSection'>
			        	<?php echo bsh_docs_get_support() ?>
			   		</section>

	        	</div>
	        	<div class='clear'></div>
	        </div>

        <?php
    }


}


/***********************************************/
/*       2. Instantiating The Options          */
/***********************************************/
/* Removed b/c Visual Editor was not working in wp 4.3 + 
if ( is_admin() ) {
    add_action( 'load-post.php', 'call_bshListPageOptions' );
}
function call_bshListPageOptions() {
	global $bshPostOptions;
	if( $bshPostOptions->get_page_template() == 'template-bshListPage.php' ) {
    	return new bshListPageOptions();
    }
}
*/



?>