;(function ($, window, undefined) {
	var $page_template = $('#page_template');
	var post_id = $( '#post_ID' ).val();
	var $options_container = $( '#bshPostOptions' );

	$page_template.on( 'change', function(){
		addLoader();
		$.ajax({
			url: ajaxurl,
			type: 'post',
			dataType: 'json',
			data: {
				action: 'show_post_options',
				post_ID: post_id,
				template: $page_template.val(),
			},
			success: function( response ) {
				if( response.type === 'success' ) {
					$options_container.find( '.inside' ).html( response.options );
					$options_container.find( 'h3.hndle span' ).html( response.args.title );
					$('#bshPostOptions').show();
				}
				if( response.type === 'nooptions' ) {
					$('#bshPostOptions').hide();
				}
				removeLoader();
			}
		});
	})

	$( '#bshMenu li' ).live( 'click', function() {
		var index = $(this).index();

		switchToGroup( index );
	})

	$('.datetimepicker').each( function() {
		$(this).datetimepicker({
			dateFormat: 'd MM, yy',
			altField: $(this).next(),
			altFieldTimeOnly: false,
			altFormat: 'yy-mm-dd'
		});
	})

	$('.datetimepicker').on( 'change', function() {
		if( $(this).val() === '' ) {
			$(this).next().val( '' );
		}
	})

	$('.checkAll').live( 'click', function() {
		$(this).parents( '.option:first' ).find( 'input[type="checkbox"]' ).attr( 'checked', 'checked' )
	})

	$('.checkNone').live( 'click', function() {
		$(this).parents( '.option:first' ).find( 'input[type="checkbox"]' ).removeAttr( 'checked' )
	})


	function switchToGroup( index ) {
		$( '#bshMenu li' ).removeClass('active');
		$( '#bshOptions section' ).removeClass('active');

		$( '#bshMenu li' ).eq(index).addClass('active');
		$( '#bshOptions section' ).eq(index).addClass('active');
	}


	function addLoader() {
		$('#bshLoad').fadeIn( 400 );
	}

	function removeLoader() {
		$('#bshLoad').fadeOut( 400 );
	}


})(jQuery, this);