<?php
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file contains the audi player
	widget. This widget lets you select an album
	and add it to the sidebar
*/

/***********************************************/
/*              Table of Contents              */
/***********************************************/
/*
	1. Upcoming Events Widget Class
		1.1 Constructor
		1.2 Backend Form
		1.3 Save Widget Options
		1.4 Frontend Widget Display

	2. Widget Registration

*/

/***********************************************/
/*      1. Upcoming Events Widget Class        */
/***********************************************/

class bshAudioplayerWidget extends WP_Widget {

    var $image_field = 'image';

	// 1.1 Constructor
	function bshAudioplayerWidget() {
        //parent::WP_Widget(
		parent::__construct(
        	false,
        	__( 'Musico: Audio Player', THEMENAME ),
        	array(
        		'description' => __( 'This widget allows you to add an album player to a sidebar', THEMENAME )
        	)
        );
    }

	// 1.2 Backend Form
	function form( $instance ) {
		$defaults = array(
			'title'               => '',
			'album_id'            => '',
			'buy_text'            => 'Buy',
			'image'               => '',
			'track_ids'           => ''
		);
 		$values = wp_parse_args( $instance, $defaults );
 		$image  = new WidgetImageField( $this, $values['image'] );
		?>
        <p>
        	<label for='<?php echo $this->get_field_id( 'title' ); ?>'>
        		<?php _e( 'Title:', THEMENAME ); ?>
        		<input class='widefat' id='<?php echo $this->get_field_id( 'title' ); ?>' name='<?php echo $this->get_field_name( 'title' ); ?>' type='text' value='<?php echo $values['title']; ?>' />
        	</label>
        </p>

        <p>
        	<label for='<?php echo $this->get_field_id( 'buy_text' ); ?>'>
        		<?php _e( 'Buy Text:', THEMENAME ); ?>
        		<input class='widefat' id='<?php echo $this->get_field_id( 'buy_text' ); ?>' name='<?php echo $this->get_field_name( 'buy_text' ); ?>' type='text' value='<?php echo $values['buy_text']; ?>' />
        	</label>
        </p>

        <p>
        	<label for='<?php echo $this->get_field_id( 'album_id' ); ?>'>
        		<?php _e( 'Select An Album To Player:', THEMENAME ); ?>
        		<select class='widefat' id='<?php echo $this->get_field_id( 'album_id' ); ?>' name='<?php echo $this->get_field_name( 'album_id' ); ?>'>
        			<?php
        				$albums = get_posts( 'post_type=album' );
        				foreach( $albums as $album ) {
        					echo '<option value="' . $album->ID . '">' . $album->post_title . '</option>';
        				}
        			?>
	        	</select>
           	</label>
        </p>

        <hr>

        <h3><?php _e( 'Advanced Customization', THEMENAME ) ?></h3>

        <?php _e( '<p>If you want to show tracks from different albums in this player you can customize it below. You will need to add a custom image for the album cover and you will have to specify the ID of each track.</p><p>To find the track ID\'s go to the "Media" section and search for the track. Click on it and take a look at the URL. There should be something like "?post=55" where 55 is the track ID. Add these ids, separated by commas into the field below.</p>'  ) ?>


        <p>
            <label><?php _e( 'Custom Album Cover:', THEMENAME ); ?></label>
            <?php echo $image->get_widget_field(); ?>
        </p>

        <p>
        	<label for='<?php echo $this->get_field_id( 'track_ids' ); ?>'>
        		<?php _e( 'Custom Track IDs:', THEMENAME ); ?>
        		<input class='widefat' id='<?php echo $this->get_field_id( 'track_ids' ); ?>' name='<?php echo $this->get_field_name( 'track_ids' ); ?>' type='text' value='<?php echo $values['track_ids']; ?>' />
        	</label>
        </p>



        <?php
    }

	// 1.3 Save Widget Options
	function update( $new_instance, $old_instance ) {
		$new_instance['buy_text'] = ( empty( $new_instance['buy_text'] ) ) ? 'Buy' : $new_instance['buy_text'];
  		$new_instance[$this->image_field] = intval( strip_tags( $new_instance[$this->image_field] ) );
        return $new_instance;
    }

	// 1.4 Frontend Widget Display
	function widget( $args, $instance ) {
		global $post, $wpdb, $wp_query;
		$audiplayer_id = 'audiplayer-' . $args['id'];
		echo $args['before_widget'];
		echo $args['before_title'] . $instance['title'] .  $args['after_title'];

		$audio = array();
		$track_ids = str_replace( ' ', '', $instance['track_ids'] );

		if( !empty( $track_ids ) ) {
			$tracks = $wpdb->get_results( "SELECT ID, post_title, guid FROM $wpdb->posts WHERE ID IN( $track_ids ) AND post_type = 'attachment' AND post_mime_type LIKE '%audio%' ORDER BY menu_order ASC" );
		}
		else {
			$tracks = $wpdb->get_results( "SELECT ID, post_title, guid FROM $wpdb->posts WHERE post_parent = " . $instance['album_id'] . " AND post_type = 'attachment' AND post_mime_type LIKE '%audio%' ORDER BY menu_order ASC" );
		}



		if( !empty( $instance['image'] ) OR !empty( $track_ids ) ) {
			$cover = wp_get_attachment_image_src( $instance['image'], 'musico_album_thumb' );
		}
		else {
			$thumbnail_id = get_post_thumbnail_id( $instance['album_id'] );
			$cover = wp_get_attachment_image_src( $thumbnail_id, 'musico_album_thumb' );
		}

		$i=1;
		foreach( $tracks as $track ) {

			$buy      = get_post_meta( $track->ID, '_mus_buylink', true );
			$duration = get_post_meta( $track->ID, '_mus_duration', true );
			$artist   = get_post_meta( $track->ID, '_mus_artist', true );

			$duration = empty( $duration ) ? '0:00' : $duration;
			$artist = empty( $artist ) ? get_bloginfo() : $artist;

			$tracknumber = get_post_meta( $track->ID, '_mus_tracknumber', true );
			$tracknumber = empty( $tracknumber ) ? $i*100 : $tracknumber;

			$audio[$tracknumber] = array(
				'ID'       => $track->ID,
				'mp3'      => $track->guid,
				'rating'   => 5,
				'title'    => $track->post_title,
				'buy'      => $buy,
				'duration' => $duration,
				'artist'   => $artist,
				'cover'	   => $cover[0],
			);

			$i++;
		}

		ksort( $audio );

		$audiolist = array();
		if( !empty( $track_ids ) ) {
			foreach( $audio as $item ) {
				$audiolist[$item['ID']] = $item;
			}
			$audio = array();
			$tracks = explode( ',', $track_ids );
			$tracks = array_map( 'trim', $tracks );
			foreach( $tracks as $id ) {
				$audio[] = $audiolist[$id];
			}
		}



	?>

		<div id='audioplayer-<?php echo $audiplayer_id ?>'></div>
		<script type='text/javascript'>

		options = {
		    buyText:'<?php echo $instance['buy_text'] ?>',
		    tracksToShow:999,
		    autoplay:false,
	        jPlayer:{
				swfPath: mus.template_url + '/javascripts/source/external/',
	            solution: 'flash, html'
	        },
		};

		playlist = [

			<?php foreach( $audio as $track ) : ?>
			{
				mp3:'<?php echo $track['mp3'] ?>',
				rating:<?php echo $track['rating'] ?>,
				title:'<?php echo addslashes( $track['title'] ) ?>',
				<?php if( !empty( $track['buy'] ) ) : ?>
				buy:'<?php echo $track['buy'] ?>',
				<?php endif ?>
				duration:'<?php echo $track['duration'] ?>',
				artist:'<?php echo $track['artist'] ?>',
				cover:'<?php echo $track['cover'] ?>'
			},
			<?php endforeach ?>

		];

		jQuery( document ).ready( function() {
			jQuery( '#audioplayer-<?php echo $audiplayer_id ?>' ).ttwMusicPlayer(playlist, options);
			jQuery('#audioplayer-<?php echo $audiplayer_id ?>').bind( 'mbInterfaceBuilt', function(){
				sidebar_height();
			})
		})
		</script>

	<?php

		echo $args['after_widget'];
    }
}


/***********************************************/
/*          2. Widget Registration             */
/***********************************************/

register_widget('bshAudioplayerWidget');


?>