<?php
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This is the main functions file for the
	theme. Any functionality added starts here,
	either by being coded here, or being included
	here.

*/

/***********************************************/
/*              Table of Contents              */
/***********************************************/
/*
	1. Theme Setup and Config
		1.1  Constants And Setup
		1.2  Image Size Definitions
		1.3  Theme Customzier Class
		1.4  Color Manipulation Class
		1.5  Shortcodes
		1.6  Available Navigation Menus
		1.7  Available Sidebars
		1.8  Widget Image Upload Class
		1.9  Widgets
		1.10 Page Template Options
		1.11 Custom Post Types
		1.12 Custom Post Type Messages

	2. Scripts and Styles
		2.1 Frontend Scripts
		2.2 Frontend Styles
		2.3 Google Maps Integration
		2.4 Tracking Code Integration

	3. Information Retrieving Functions
		3.1 Page Meta
			3.1.1 Canonical URL
			3.1.2 Page Title
			3.1.3 Page Image

	4. Backend Functions
		4.1 Custom Post Icons
		4.2 Additional Image Fields - Edit
		4.3 Additional Image Fields - Save

	5. Frontend Functions
		5.1  Comment Display
		5.2  Pagination
		5.3  Default Menu
		5.4  Shortcode Cleanup
		5.5  No Posts Fallback
		5.6  Image Formater
		5.7  Page Title Checker
		5.8  Analytics Code
		5.9  Customized Gallery Display
		5.10 Determine Layout Size
		5.11 Get Audio Tracks
		5.12 Dropdown Walker
		5.13 Default Menu
		5.14 Default Dropwdown

	6. Theme Option Functions
		6.1 Custom Sidebar Generation
		6.2 Get Setting Value
		6.3 Has Sidebar
		6.4 Get Assigned Sidebar
		6.5 Get Page Layout
		6.6 Color Translator
		6.7 Content Area Classes
		6.8 Sidebar Area Classes

	7. Documentation Functions
		7.1 Online Help Documentation
		7.2 Shortcode Documentation

	8. Integrations
		8.1 Twitter Integration
		8.2 Facebook Integration
		8.3 Twitter API

*/

/***********************************************/
/*         1. Theme Setup and Config           */
/***********************************************/

// 1.1 Constants And Setup
define( 'THEMEVERSION', '1.1' );
define( 'COMPANYPREFIX', 'bsh' );
define( 'THEMENAME', 'musico' );
define( 'THEMEPREFIX', 'mus' );
define( 'BSH_GOOGLE_API_KEY', 'AIzaSyCD2NXkx_PIHullgn7_FaEqsr7CmuIbfBM' );
define( 'BSH_FACEBOOK_API_KEY', '151174081701425' );
define( 'BSH_TWITTER_CONSUMER_KEY', 'QWdKTKeTKXf9cdxraARVEA' );
define( 'BSH_TWITTER_CONSUMER_SECRET', 'Ah8Zpg1ymWem2Dj3c1OS1Rcq6Xh0jpHYmjQPLUlCrPM' );
define( 'BSH_TWITTER_ACCESS_TOKEN', '772364892-habgBBoijKTIfInkydJvcfSpxgJc116VWrlKGmRE' );
define( 'BSH_TWITTER_ACCESS_SECRET', '5syRRX89lahrOi6epHgwtDBT3WMiMzU0Da1uoOCI1M' );

add_action( 'wp_head', 'mus_content_width' );
function mus_content_width( $content ) {
	global $content_width, $post;
	if( bsh_has_sidebar() ) {
		$content_width = 628;
	}
	else {
		$content_width = 986;
	}
}
add_theme_support( 'automatic-feed-links' );
add_filter( 'gallery_style', '__return_false', 99 );


// 1.2 Image Size Definitions
add_theme_support('post-thumbnails');
add_image_size( 'gallery', 400, 400 );

add_image_size( 'mus_large', 1052, 9999 );
add_image_size( 'mus_large_sb', 628, 9999 );

add_image_size( 'mus_slider', 978, 553, true );
add_image_size( 'mus_slider_sb', 620 ,351, true );

add_image_size( 'album', 225, 225, true );
add_image_size( 'sidebar', 270, 888 );

// 1.3 Theme Customizer Class
include( 'framework/customizer/Customizer.class.php' );
add_action ('admin_menu', COMPANYPREFIX . '_theme_customizer');
function bsh_theme_customizer() {
	add_theme_page(
		__( 'Customize The Musico Design and Theme Options', THEMENAME ),
		__( 'Customize Theme', THEMENAME ),
		'edit_theme_options',
		'customize.php'
	);
}

// 1.4 Color Manipulation Class
include( 'framework/external/Color/Color.class.php' );

// 1.5 Shortcodes
include( 'framework/shortcodes.php' );
add_filter('widget_text', 'do_shortcode');


// 1.6 Available Navigation Menus
register_nav_menus( array(
	'header_menu' => __( 'Header menu', THEMENAME ),
	'footer_menu' => __( 'Footer Menu', THEMENAME )
));

// 1.7 Available Sidebars
register_sidebar( array(
	'name'          => __( 'Sidebar', THEMENAME ),
	'id'			=> 'sidebar-default',
	'description'   => __( 'The default Musico sidebar', THEMENAME ),
	'before_widget' => '<div id="%1$s" class="widget %2$s">',
	'after_widget'  => '</div>',
	'before_title'  => '<h1 class="widget-title">',
	'after_title'   => '</h1>'
));

register_sidebar( array(
	'name'          => __( 'Search Page Sidebar', THEMENAME ),
	'id'			=> 'sidebar-search',
	'description'   => __( 'The default Sidebar for the search page', THEMENAME ),
	'before_widget' => '<div id="%1$s" class="widget %2$s">',
	'after_widget'  => '</div>',
	'before_title'  => '<h1 class="widget-title">',
	'after_title'   => '</h1>'
));



// 1.8 Widget Image Upload Class
include( 'framework/external/imageUpload/imageUpload.class.php' );


// 1.9 Widgets
include( 'framework/widgets/ContactWidget.class.php' );
include( 'framework/widgets/TwitterWidget.class.php' );
include( 'framework/widgets/FeaturedItemWidget.class.php' );
include( 'framework/widgets/LatestPostsWidget.class.php' );
include( 'framework/widgets/UpcomingEventsWidget.class.php' );
include( 'framework/widgets/AudioplayerWidget.class.php' );

// 1.10 Page Template Options
include( 'framework/template-options/bshOptions.class.php' );
include( 'framework/template-options/bshPostOptions.class.php' );
include( 'framework/template-options/bshDefaultOptions.class.php' );
include( 'framework/template-options/bshListPageOptions.class.php' );
include( 'framework/template-options/bshEventListPageOptions.class.php' );
include( 'framework/template-options/bshEventOptions.class.php' );
include( 'framework/template-options/bshAlbumOptions.class.php' );
$bshPostOptions = new bshOptions();

// 1.11 Custom Post Types
add_action( 'init', COMPANYPREFIX . '_post_types' );
function bsh_post_types() {

	$labels = array(
		'name'                => __( 'Events', THEMENAME ),
		'singular_name'       => __( 'Event', THEMENAME ),
		'add_new'             => __( 'Add New', THEMENAME ),
		'add_new_item'        => __( 'Add New Event', THEMENAME ),
		'edit_item'           => __( 'Edit Event', THEMENAME ),
		'new_item'            => __( 'New Event', THEMENAME ),
		'all_items'           => __( 'All Events', THEMENAME ),
		'view_item'           => __( 'View Event', THEMENAME ),
		'search_items'        => __( 'Search Events', THEMENAME ),
		'not_found'           => __( 'No events found', THEMENAME ),
		'not_found_in_trash'  => __( 'No events found in Trash', THEMENAME ),
		'menu_name'           => __( 'Events', THEMENAME ),
	);

	$args = array(
		'labels'              => $labels,
		'public'              => true,
		'publicly_queryable'  => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'query_var'           => true,
		'rewrite'             => array( 'slug' => 'event' ),
		'capability_type'     => 'post',
		'has_archive'         => true,
		'hierarchical'        => false,
		'menu_position'       => null,
		'supports'            => array( 'title', 'editor', 'thumbnail', 'excerpt' )
	);

	register_post_type( 'event', $args );


	$labels = array(
		'name'                => __( 'Albums', THEMENAME ),
		'singular_name'       => __( 'Album', THEMENAME ),
		'add_new'             => __( 'Add New', THEMENAME ),
		'add_new_item'        => __( 'Add New Album', THEMENAME ),
		'edit_item'           => __( 'Edit Album', THEMENAME ),
		'new_item'            => __( 'New Album', THEMENAME ),
		'all_items'           => __( 'All Albums', THEMENAME ),
		'view_item'           => __( 'View Album', THEMENAME ),
		'search_items'        => __( 'Search Albums', THEMENAME ),
		'not_found'           => __( 'No albums found', THEMENAME ),
		'not_found_in_trash'  => __( 'No albums found in Trash', THEMENAME ),
		'menu_name'           => __( 'Albums', THEMENAME ),
	);

	$args = array(
		'labels'              => $labels,
		'public'              => true,
		'publicly_queryable'  => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'query_var'           => true,
		'rewrite'             => array( 'slug' => 'album' ),
		'capability_type'     => 'post',
		'has_archive'         => true,
		'hierarchical'        => false,
		'menu_position'       => null,
		'supports'            => array( 'title', 'editor', 'thumbnail', 'excerpt' )
	);

	register_post_type( 'album', $args );


}



// 1.12 Custom Post Type Messages
add_filter( 'post_updated_messages', COMPANYPREFIX . '_post_type_messages' );
function bsh_post_type_messages( $messages ) {
	global $post, $post_ID;

	$messages['event'] = array(
		0  => '',
		1  => sprintf( __('Event updated. <a href="%s">View event</a>', THEMENAME),
			  esc_url( get_permalink($post_ID) ) ),
		2  => __('Custom field updated.', THEMENAME),
		3  => __('Custom field deleted.', THEMENAME),
		4  => __('Event updated.', THEMENAME),
		5  => isset($_GET['revision']) ? sprintf( __('Event restored to revision from %s',
			  THEMENAME), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
		6  => sprintf( __('Event published. <a href="%s">View event</a>', THEMENAME),
			  esc_url( get_permalink($post_ID) ) ),
		7  => __('Event saved.', THEMENAME),
		8  => sprintf( __('Event submitted. <a target="_blank" href="%s">Preview event</a>',
			  THEMENAME), esc_url( add_query_arg( 'preview', 'true', get_permalink($post_ID) ) ) ),
		9  => sprintf( __('Event scheduled for: <strong>%1$s</strong>. <a target="_blank" href="%2$s">Preview event</a>', THEMENAME),
			date_i18n( __( 'M j, Y @ G:i', THEMENAME ), strtotime( $post->post_date ) ),
			esc_url( get_permalink($post_ID) ) ),
		10 => sprintf( __('Event draft updated. <a target="_blank" href="%s">Preview event</a>',
			  THEMENAME), esc_url( add_query_arg( 'preview', 'true', get_permalink($post_ID) ) ) ),
	);

	$messages['album'] = array(
		0  => '',
		1  => sprintf( __('Album updated. <a href="%s">View album</a>', THEMENAME),
			  esc_url( get_permalink($post_ID) ) ),
		2  => __('Custom field updated.', THEMENAME),
		3  => __('Custom field deleted.', THEMENAME),
		4  => __('Album updated.', THEMENAME),
		5  => isset($_GET['revision']) ? sprintf( __('Album restored to revision from %s',
			  THEMENAME), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
		6  => sprintf( __('Album published. <a href="%s">View album</a>', THEMENAME),
			  esc_url( get_permalink($post_ID) ) ),
		7  => __('Album saved.', THEMENAME),
		8  => sprintf( __('Album submitted. <a target="_blank" href="%s">Preview album</a>',
			  THEMENAME), esc_url( add_query_arg( 'preview', 'true', get_permalink($post_ID) ) ) ),
		9  => sprintf( __('Album scheduled for: <strong>%1$s</strong>. <a target="_blank" href="%2$s">Preview album</a>', THEMENAME),
			date_i18n( __( 'M j, Y @ G:i', THEMENAME ), strtotime( $post->post_date ) ),
			esc_url( get_permalink($post_ID) ) ),
		10 => sprintf( __('Album draft updated. <a target="_blank" href="%s">Preview album</a>',
			  THEMENAME), esc_url( add_query_arg( 'preview', 'true', get_permalink($post_ID) ) ) ),
	);


	return $messages;
}





/***********************************************/
/*            2. Scripts and Styles            */
/***********************************************/

// 2.1 Frontend Scripts
add_action('wp_enqueue_scripts',  COMPANYPREFIX . '_frontend_scripts');
function bsh_frontend_scripts() {
	if( !is_admin() ) {
		wp_register_script(
			'scripts',
			get_template_directory_uri() . '/javascripts/scripts.min.js',
			array( 'jquery' ),
			THEMEVERSION
		);

		wp_register_script(
			'app',
			get_template_directory_uri() . '/javascripts/app.min.js',
			array( 'jquery', 'scripts' ),
			THEMEVERSION
		);

		wp_register_script(
			'playlist',
			get_template_directory_uri() . '/javascripts/playlist.min.js',
			array( 'jquery', 'scripts' ),
			THEMEVERSION
		);

		if ( is_singular() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}

		wp_localize_script( 'playlist', 'mus', array( 'template_url' => get_template_directory_uri(), 'url' => site_url() ) );


		wp_enqueue_script( 'jquery' );
		wp_enqueue_script( 'playlist' );
		wp_enqueue_script( 'scripts' );
		wp_enqueue_script( 'app' );
	}
}

// 2.2 Frontend Styles
add_action('wp_enqueue_scripts', COMPANYPREFIX . '_frontend_styles');
function bsh_frontend_styles() {
	if( !is_admin() ) {
		wp_register_style(
			'musico',
			get_bloginfo( 'stylesheet_url' ),
			array(),
			THEMEVERSION
		);
		wp_enqueue_style( 'musico' );
	}
}

// 2.3 Google Maps Integration
add_action( 'wp_head', COMPANYPREFIX . '_google_maps_api' );
function bsh_google_maps_api() {
	$api_key = get_theme_mod('google_maps_api_key');
	$api_key = ( empty( $api_key ) ) ? BSH_GOOGLE_API_KEY : $api_key;
	echo '<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=' . $api_key . '&sensor=false"></script>';
}

// 2.4 Tracking Code Integration
add_action( 'wp_footer', COMPANYPREFIX . '_tracking_code' );
function bsh_tracking_code() {
	$tracking_code = get_theme_mod('analytics');
	if( !empty( $tracking_code ) ) {
		echo $tracking_code;
	}
}



/***********************************************/
/*     3. Information Retrieving Functions     */
/***********************************************/

/*********************************/
/*         3.1 Page Meta         */
/*********************************/

// 3.1.1 Canonical URL
/*
Used to get a standard link for any page. Used in
meta tags in the header
*/
function bsh_canonical_url() {

	if( is_home() OR is_front_page() ) {
		$url = 	home_url();
	}
	elseif( is_singular() ) {
		global $post;
		$url = get_permalink( $post->ID );
	}
	else {
		global $wp;
		$url = add_query_arg( $wp->query_string, '', home_url( $wp->request ) );
	}

	return $url;

}

// 3.1.2 Page Title
/*
Used to get a standard title for any page. Used in
meta tags in the header
*/
function bsh_page_title() {
	global $page, $paged;

	ob_start();

	bloginfo();
	wp_title( '' );

	$site_description = get_bloginfo( 'description', 'display' );

	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";

	if ( $paged >= 2 || $page >= 2 )
		echo ' | Page ' . max( $paged, $page );

	$title = ob_get_clean();
	$title = trim( $title );
	return $title;

}

// 3.1.3 Page Image
/*
Used to get an attached image for any page.
Used in meta tags in the header
*/
function bsh_page_image() {
	global $post;

	$image = '';
	$image_id = '';
	if( is_singular() ) {
		$image_id = get_post_thumbnail_id( $post->ID );
	}

	if( !empty( $image_id ) ) {
		$image = wp_get_attachment_image_src( $image_id, 'thumbnail' );
		$image = $image[0];
	}

	return $image;

}


/***********************************************/
/*            4. Backend Functions             */
/***********************************************/

// 4.1 Custom Post Icons
add_action( 'admin_head', COMPANYPREFIX . '_icons' );
function bsh_icons() {
    ?>
        <style type="text/css" media="screen">
            #menu-posts-album .wp-menu-image {
                background: url( <?php echo get_stylesheet_directory_uri() ?>/images/custom-posts/album.png ) no-repeat center 3px !important;
            }
            #menu-posts-album:hover .wp-menu-image, #menu-posts-album.current .wp-menu-image, #menu-posts-album.wp-has-current-submenu .wp-menu-image {
                background: url( <?php echo get_stylesheet_directory_uri() ?>/images/custom-posts/album.png ) no-repeat center -27px !important;
            }            
            #adminmenu #menu-posts-album div.wp-menu-image:before {
                content: "";
            }
            #menu-posts-event .wp-menu-image {
                background: url( <?php echo get_stylesheet_directory_uri() ?>/images/custom-posts/event.png ) no-repeat center 3px !important;
            }
            #menu-posts-event:hover .wp-menu-image, #menu-posts-event.current .wp-menu-image, #menu-posts-event.wp-has-current-submenu .wp-menu-image {
                background: url( <?php echo get_stylesheet_directory_uri() ?>/images/custom-posts/event.png ) no-repeat center -27px !important;
            }            
            #adminmenu #menu-posts-event div.wp-menu-image:before {
                content: "";
            }

        </style>
<?php
}

// 4.2 Additional Image Fields - Edit
add_filter( 'attachment_fields_to_edit', 'mus_attachment_fields_to_edit', null, 2);
function mus_attachment_fields_to_edit($form_fields, $post) {

	if( substr_count( $post->post_mime_type, 'audio' ) > 0 ) {
	    $form_fields["mus_buylink"] = array(
	        "label" => __("Buy Link", THEMENAME),
	        "input" => "text", // this is default if "input" is omitted
	        "value" => get_post_meta($post->ID, "_mus_buylink", true)
	    );
	    $form_fields["mus_duration"] = array(
	        "label" => __("Track Length", THEMENAME),
	        "input" => "text", // this is default if "input" is omitted
	        "value" => get_post_meta($post->ID, "_mus_duration", true)
	    );
	    $form_fields["mus_artist"] = array(
	        "label" => __("Artist", THEMENAME),
	        "input" => "text", // this is default if "input" is omitted
	        "value" => get_post_meta($post->ID, "_mus_artist", true)
	    );
	    $form_fields["mus_tracknumber"] = array(
	        "label" => __("Track Number", THEMENAME),
	        "input" => "text", // this is default if "input" is omitted
	        "value" => get_post_meta($post->ID, "_mus_tracknumber", true)
	    );
    }

    return $form_fields;
}


// 4.2 Additional Image Fields - Save
add_filter( 'attachment_fields_to_save', 'mus_attachment_fields_to_save', null, 2);

function mus_attachment_fields_to_save($post, $attachment) {


	    if( isset($attachment['mus_buylink']) ){
	        update_post_meta($post['ID'], '_mus_buylink', $attachment['mus_buylink']);
	    }
	    if( isset($attachment['mus_duration']) ){
	        update_post_meta($post['ID'], '_mus_duration', $attachment['mus_duration']);
	    }
	    if( isset($attachment['mus_artist']) ){
	        update_post_meta($post['ID'], '_mus_artist', $attachment['mus_artist']);
	    }
	    if( isset($attachment['mus_tracknumber']) ){
	        update_post_meta($post['ID'], '_mus_tracknumber', $attachment['mus_tracknumber']);
	    }

    return $post;
}

/***********************************************/
/*            5. Frontend Functions            */
/***********************************************/

// 5.1 Comment Display
function bsh_comments( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case 'pingback' :
		case 'trackback' :
	?>
		<li <?php comment_class( 'comment pingback' ); ?> id="comment-<?php comment_ID(); ?>">
			<article class='primary-links'>

				<span class='pingback-title'>
					<?php _e( 'Pingback', THEMENAME ) ?>
				</span>
				<span class='pingback-content'>
				<?php comment_author_link(); ?>
				</span>

				<?php edit_comment_link( 'Edit', ' - <span class="edit-link">', '</span>' ); ?>
			</article>
	<?php
		break;
		default :
	?>
		<li <?php comment_class( 'comment' ); ?> id="comment-<?php comment_ID(); ?>">
				<?php if ( $comment->comment_approved == '0' ) : ?>
					<div class="alert-box comment-awaiting-moderation">
					<?php _e( 'Your comment is awaiting moderation.', THEMENAME ); ?>
					<a href="" class="close">&times;</a>
					</div>
				<?php endif; ?>

			<article>
				<?php echo get_avatar( $comment, 50 ) ?>
				<header class='comment-meta comment-author vcard'>
					<cite class='fn heading-font'><?php comment_author_link() ?></cite>
					<span class='comment-time body-text-lighter'><?php comment_time( 'F d Y \a\t H:i a' ) ?></span>
				</header>
				<section class='comment-content'>
					<?php comment_text() ?>
				</section>

				<span class='primary-links'>
					<?php
						comment_reply_link( array_merge( $args, array(
							'reply_text' => 'Reply',
							'depth' => $depth,
							'max_depth' => $args['max_depth']
						)));
					?>

					<?php edit_comment_link( 'Edit', ' - <span class="edit-link">', '</span>' ); ?>
				</span>

			</article>
	<?php
	break;
	endswitch;
}


// 5.2 Pagination
function bsh_pagination( $query = false ) {
	if( $query == false ) {
		global $wp_query;
		$query = $wp_query;
	}
	$pagination = array(
		'base'      => str_replace( 99999, '%#%', get_pagenum_link( 99999 ) ),
		'format'    => '?paged=%#%',
		'current'   => max( 1, get_query_var( 'paged' ) ),
		'total'     => $query->max_num_pages,
		'next_text' => 'next',
		'prev_text' => 'previous'
	);
	ob_start();
	echo paginate_links( $pagination );
	$pagination = ob_get_clean();
	$pagination = str_replace( array( '>next<', '>previous<' ), array( '>&gt;<', '>&lt;<' ), $pagination );
	echo $pagination;

}

// 5.3 Default Menu
function mus_default_menu( $args ) {
	ob_start();
	wp_page_menu();
	$menu = ob_get_clean();
	$menu = preg_replace( "/<ul class='children'>(.*?)<\/ul>/", '<div class="sub-container gradient"><ul class="children">$1</ul></div>', $menu );

	echo $menu;
}

// 5.4 Shortcode Cleanup
add_filter('the_content', COMPANYPREFIX . '_clean_shortcodes' );
add_filter('widget_text', COMPANYPREFIX . '_clean_shortcodes' );
function bsh_clean_shortcodes($content){
    $array = array (
        '<p>[' => '[',
        ']</p>' => ']',
        ']<br />' => ']',
    );
    $content = strtr($content, $array);
    return $content;
}

// 5.5 No Posts Fallback
function bsh_no_posts( $title = false, $message = false) {
	$title = ( empty( $title ) ) ? get_theme_mod( 'no_posts_title' ) : $title;
	$message = ( empty( $message ) ) ? get_theme_mod( 'no_posts_message' ) : $message;

	echo '
		<hgroup class="no-content">
		<h1>' . $title . '</h1>
		<h2>' . $message . '</h2>
		</hgroup>
	';
}


// 5.6 Image Formatter

add_filter( 'post_thumbnail_html', THEMEPREFIX . '_format_image', 10, 5 );
function mus_format_image( $html = '', $post_id, $post_thumbnail_id, $size = '', $attr = '' ) {
$html = '<div class="image">' . $html . '</div>';
return $html;
}

// 5.7 Page Title Checker
function bsh_have_title() {
	global $post;
	$has_title = get_post_meta( $post->ID, '_' . THEMEPREFIX . '_title', true );
	$has_title = ( ( !empty( $has_title ) AND $has_title === 'hide' ) OR get_the_title( '', '', false ) == '' ) ? false : true;
	return $has_title;
}

// 5.8 Analytics Code
add_action( 'wp_footer', COMPANYPREFIX . '_analytics_code' );
function bsh_analytics_code() {
	$code = get_theme_mod( 'analytics' );
	if( !empty( $code ) ) {
		echo $code;
	}
}

// 5.9 Customized Gallery Display
remove_shortcode('gallery', 'gallery_shortcode');
add_shortcode('gallery', 'gallery_shortcode_fancybox');
function gallery_shortcode_fancybox($attr) {
	$post = get_post();

	static $instance = 0;
	$instance++;

	if ( ! empty( $attr['ids'] ) ) {
		// 'ids' is explicitly ordered, unless you specify otherwise.
		if ( empty( $attr['orderby'] ) )
			$attr['orderby'] = 'post__in';
		$attr['include'] = $attr['ids'];
	}

	// Allow plugins/themes to override the default gallery template.
	$output = apply_filters('post_gallery', '', $attr);
	if ( $output != '' )
		return $output;

	// We're trusting author input, so let's at least make sure it looks like a valid orderby statement
	if ( isset( $attr['orderby'] ) ) {
		$attr['orderby'] = sanitize_sql_orderby( $attr['orderby'] );
		if ( !$attr['orderby'] )
			unset( $attr['orderby'] );
	}

	extract(shortcode_atts(array(
		'order'      => 'ASC',
		'orderby'    => 'menu_order ID',
		'id'         => $post->ID,
		'itemtag'    => 'dl',
		'icontag'    => 'dt',
		'captiontag' => 'dd',
		'columns'    => 3,
		'size'       => 'thumbnail',
		'include'    => '',
		'exclude'    => ''
	), $attr));

	$id = intval($id);
	if ( 'RAND' == $order )
		$orderby = 'none';

	if ( !empty($include) ) {
		$_attachments = get_posts( array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );

		$attachments = array();
		foreach ( $_attachments as $key => $val ) {
			$attachments[$val->ID] = $_attachments[$key];
		}
	} elseif ( !empty($exclude) ) {
		$attachments = get_children( array('post_parent' => $id, 'exclude' => $exclude, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
	} else {
		$attachments = get_children( array('post_parent' => $id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
	}

	if ( empty($attachments) )
		return '';

	if ( is_feed() ) {
		$output = "\n";
		foreach ( $attachments as $att_id => $attachment )
			$output .= wp_get_attachment_link($att_id, $size, true) . "\n";
		return $output;
	}

	$itemtag = tag_escape($itemtag);
	$captiontag = tag_escape($captiontag);
	$icontag = tag_escape($icontag);
	$valid_tags = wp_kses_allowed_html( 'post' );
	if ( ! isset( $valid_tags[ $itemtag ] ) )
		$itemtag = 'dl';
	if ( ! isset( $valid_tags[ $captiontag ] ) )
		$captiontag = 'dd';
	if ( ! isset( $valid_tags[ $icontag ] ) )
		$icontag = 'dt';

	$columns = intval($columns);
	$itemwidth = $columns > 0 ? floor(100/$columns) : 100;
	$float = is_rtl() ? 'right' : 'left';

	$selector = "gallery-{$instance}";

	$gallery_style = $gallery_div = '';
	if ( apply_filters( 'use_default_gallery_style', true ) )
		$gallery_style = "
		<style type='text/css'>
			#{$selector} {
				margin: auto;
			}
			#{$selector} .gallery-item {
				float: {$float};
				margin-top: 10px;
				text-align: center;
				width: {$itemwidth}%;
			}
			#{$selector} img {
				border: 2px solid #cfcfcf;
			}
			#{$selector} .gallery-caption {
				margin-left: 0;
			}
		</style>
		<!-- see gallery_shortcode() in wp-includes/media.php -->";
	$size_class = sanitize_html_class( 'gallery' );
	$gallery_div = "<div id='$selector' class='gallery galleryid-{$id} gallery-columns-{$columns} gallery-size-{$size_class}'>";
	$output = apply_filters( 'gallery_style', $gallery_style . "\n\t\t" . $gallery_div );

	$i = 0;
	foreach ( $attachments as $id => $attachment ) {
		$image_gallery = wp_get_attachment_image_src($id, 'gallery' );
		$image_large = wp_get_attachment_image_src($id, 'full' );

		$link = '<a title="' . $attachment->post_excerpt . '" href="' . $image_large[0] . '" rel="lightbox"><img src="' . $image_gallery[0] . '"></a>';

		$output .= "<{$itemtag} class='gallery-item'>";
		$output .= "
			<{$icontag} class='gallery-icon'>
				$link
			</{$icontag}>";
		if ( $captiontag && trim($attachment->post_excerpt) ) {
			$output .= "
				<{$captiontag} class='wp-caption-text gallery-caption'>
				" . wptexturize($attachment->post_excerpt) . "
				</{$captiontag}>";
		}
		$output .= "</{$itemtag}>";
	}

	$output = '<div class="gallery">' . $output . '</div>';

	return $output;
}

// 5.10 Determine Layout Size
function bsh_get_layout_size( $image_size ) {
	if ( bsh_has_sidebar() ) {
		return $image_size . '_sb';
	}
	else {
		return $image_size;
	}
}

// 5.11 Get Audio Tracks
function mus_get_tracks( $post_id ) {
	global $wpdb;
	$tracks = $wpdb->get_results( "SELECT ID, post_title, guid FROM $wpdb->posts WHERE post_parent = $post_id AND post_type = 'attachment' AND post_mime_type LIKE '%audio%' ORDER BY menu_order ASC " );
	return $tracks;

}


// 5.12 Dropdown Walker

class Walker_Nav_Menu_Dropdown extends Walker_Nav_Menu{
	//function start_lvl(&$output, $depth){
	function start_lvl(&$output, $depth = 0, $args = array()) {
		$indent = str_repeat("\t", $depth);
	}

	//function end_lvl(&$output, $depth){
	function end_lvl(&$output, $depth = 0, $args = array()) {
		$indent = str_repeat("\t", $depth);
	}

	//function start_el(&$output, $item, $depth, $args){
	function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0){
		global $wp, $post;
		$item = (object) $item;
		$title = str_repeat("&nbsp;", $depth * 4) . $item->post_title;

		$title = $item->post_title;
		$url = $item->url;

		if( empty( $title ) ) {
			$title = $item->title;
		}

		if( empty( $url ) ) {
			$url = $item->guid;
		}

		$current_url = home_url(add_query_arg(array(),$wp->request));
	 	$selected = ( $current_url == $item->url OR $current_url . '/' == $item->url OR $post->ID == $url ) ? 'selected="selected"' : '';
		$output .= '<option ' . $selected . ' value="' . $url . '">' . $title;
	}

	//function end_el(&$output, $item, $depth){
	function end_el(&$output, $item, $depth = 0, $args = array()){
		$output .= "</option>\n";
	}
}

// 5.13 Default Menu

function bsh_default_menu() {
	wp_page_menu( array(
		'menu_class' => 'menu menu-normal',
		'show_home'  => true
	));
}

// 5.14 Default Dropwdown

function bsh_default_dropdown() {
	global $post;
	echo '<div class="menu-select" style="display:none">';
	wp_dropdown_pages( array( 'selected' => $post->ID ) );
	echo '</div>';
}



/***********************************************/
/*          6. Theme Option Functions          */
/***********************************************/

// 6.1 Custom Sidebar Generation
$choices = explode(',', get_theme_mod( 'sidebars' ) );
foreach( $choices as $choice ) {
	$choice = trim( $choice );
	$i = count($wp_registered_sidebars) + 1;
	if( !empty( $choice ) ) {

		register_sidebar( array(
			'name'          => $choice,
			'id' 			=> "sidebar-$i",
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h1 class="widget-title">',
			'after_title'   => '</h1>'
		));


	}
}

// 6.2 Get Setting Value
function bsh_get_page_setting( $setting, $default = '' ) {
    global $post;
    $value = get_post_meta( $post->ID, '_' . THEMEPREFIX . '_' . $setting, true );

    if( empty( $value ) OR $value == 'default' ) {
    	$value = get_theme_mod( $setting );
    }
    if( empty( $value ) ) {
    	$value = $default;
    }
    return $value;
}


// 6.3 Has Sidebar
function bsh_has_sidebar() {
	$layout = bsh_get_layout();

	if( $layout === '1col' ) {
		return false;
	}
	else {
		return true;
	}
}


// 6.4 Get Assigned Sidebar
function bsh_get_sidebar() {
	$sidebar = get_theme_mod( 'sidebar' );
	if( is_search() ) {
		$sidebar = 'Search Page Sidebar';
	}
	elseif( is_singular() ) {
		global $post;
		$page_sidebar = get_post_meta( $post->ID, '_' . THEMEPREFIX . '_sidebar', true );
		if( !empty( $page_sidebar ) AND $page_sidebar != 'default' ) {
			$sidebar = $page_sidebar;
		}
	}
	return $sidebar;
}

// 6.5 Get Page Layout
function bsh_get_layout() {
	$layout = get_theme_mod( 'layout' );

	if( is_singular() ) {
	    global $post;
	    $layout = bsh_get_page_setting( 'layout' );
	}

	return $layout;

}


// 6.6 Color Translator
function bsh_determine_color( $color ) {
	$colors = array(
		'primary'           => get_theme_mod( 'primary_color' ),
		'primary_text'      => get_theme_mod( 'primary_text_color' ),
		'red'               => '#E23455',
		'cyan'              => '#139BC1',
		'yellow'            => '#F4D248',
		'black'             => '#4D4D4D',
		'blue'              => '#569CD1',
		'green'             => '#88BF53',
		'purple'            => '#C355BD',
		'orange'            => '#EC9F5F',
	);


	if( in_array( $color, array_keys( $colors ) ) ) {
		$final_color = $colors[ $color ];
	}
	else {
		if( substr( $color, 0, 1 ) == '#' ) {
			$final_color = $color;
		}
		else {
			$final_color = $colors['primary'];
		}
	}
	return $final_color;
}


// 6.7 Content Area Classes
function bsh_content_classes() {
	if( !bsh_has_sidebar() === true ) {
		return 'twelve';
	}
	$layout = bsh_get_layout();
	if( $layout === '2col_left' ) {
		return 'eight push-four';
	}
	else {
		return 'eight';
	}
}

// 6.8 Sidebar Area Classes
function bsh_sidebar_classes() {
	$layout = bsh_get_layout();
	if( $layout === '2col_left' ) {
		return 'pull-eight';
	}
	return;
}



/***********************************************/
/*         7. Documentation Functions          */
/***********************************************/

// 7.1 Online Help Documentation
function bsh_docs_get_support() {
		return __( '
		<p>
			Don\'t forget that there is inline help available for each specific option next to the option itself. Simply hover over the help link.</p>
		<p>
			Before you as for support make sure to read the relevant sections in the documentation you received with the theme. We also have online documentation in our <a href="http://bonsaished.com/knowledgebase/">Knowledgebase</a>. We recommend taking a look here as well.
		</p>
		<p>
			If you still have questions or you have found a possible bug, we are at your service in the <a href="http://bonsaished.com/support/theme/musico/">Support Forum</a>.If you contact us there, please make sure to include a <strong>screenshot and a link</strong> to whatever it is you have a problem with.

		</p>
	', THEMENAME );
}

// 7.3 Shortcode Documentation
function bsh_docs_shortcodes() {
	return __('
	    <p>Shortcodes are snippets of specially formatted content which you can use to liven up your website\'s content. If you don\'t know how to use them, refer to the theme documentation, or read our short guide on <a href="http://bonsaished.com/blog/kb/how-to-use-shortcodes/">How to Use Shortcodes</a> online.</p>

	    <h4>Line Shortcode</h4>

	    <h5>[line]</h5>

	    <p>The line shortcode allows you to add a separator line between two bits of content. Optionally you can add a little link inline with the line. The parameters of this shortcode are:</p>

	    <p><strong>color</strong><br>
	    By specifying a color you are controling the color of the line. Please take a look at the Color Notes for how to specify colors.</p>

	    <p><strong>url</strong><br>
	    If you would like to add a link next to the line (to take the user to the top of the page for example) you can do so by adding the url parameter. If given, a link will be generated for you. if you want the link to take users to the top of the page use \'#\' as the value for this parameter.</p>

	    <p><strong>text</strong><br>
	    The link will have the text given here. The default text is \'link\' which you will probably want to change to something more meaningful.</p>

	    <p><strong>position</strong><br>
	    You can define a position for the link. The position can be left or right (left is the default).</p><a href="http://bonsaished.com/blog/kb/line-shortcode/">View Examples Online</a>

	    <div class="separator"></div>

	    <h4>Column Shortcode</h4>

	    <h5>[row][column][/column][/row]</h5>

	    <p>Columns enable you to easily sort your content into a column based layout. Creating columns requires the use of two separate shortcodes, the [row] and the [column] shortcode. The parameters of this shortcode are:</p>

	    <p>There is only one attribute involved which needs to be added to the column shortcode to tell it how wide it should be.</p>

	    <p><strong>width</strong><br>
	    Sets the width of a column in units. Should be given as one to twelve.</p>

	    <p>There are twelve units in each row. This means that whenever you create a row you will need to distrbute 12 units throughout them. In other words you can create one \'twelve\' width column in a row or two \'six\' width coliumns, or three \'four\' width columns. The idea is that the width of all columns in a row should add up to twelve.</p>

	    <p>You don\'t have to use the same widths in a row though. You could create a \'six\' width column and two \'three\' width columns. Let\'s look at some examples.</p><a href="http://bonsaished.com/blog/kb/column-shortcode/">View Examples Online</a>

	    <div class="separator"></div>

	    <h4>Map Shortcode</h4>

	    <h5>[map]</h5>

	    <p>The map shortcode lets you put a customizable Google map centered on a location you specify anywhere in a post. The parameters of this shortcode are:</p>

	    <p><strong>location</strong><br>
	    Adding this is necessary for the map to show up. It should be an address in plain text, something you would type into the search field in Google Maps.</p>

	    <p><strong>type</strong><br>
	    The type of map to show. The value can be HYBRID, SATELLITE, ROADMAP, TERRAIN. The default value is HYBRID.</p>

	    <p><strong>zoom</strong><br>
	    Set the initial zoom level for a map. If you\'re adding a street level map somewhere around 14 (the default) is best. The zoom can range from 1 and up where 1 is the most zoomed out.</p>

	    <p><strong>marker</strong><br>
	    If set to yes, a marker will be placed at the center of the map, indicating the location you specified</p>

	    <p><strong>height</strong><br>
	    The height of the map can be set specifically if you need it. By default it is set to 400px. Don\'t forget to add the \'px\' suffix to the amount!</p><a href="http://bonsaished.com/blog/kb/map-shortcode/">View Examples Online</a>

	    <div class="separator"></div>

	    <h4>Tabs Shortcode</h4>

	    <h5>[tabs][section][/section][/tabs]</h5>

	    <p>Using the tabs shortcode you can create an area with tabbed navigation. This is great if you want to show more content in smaller area. The [tabs] shortcode is always used with the [section] shortcode, similarly to how columns are created. The parameters of this shortcode are:</p>

	    <p>The [tabs] shorcode has two attributes:</p>

	    <p><strong>contained</strong><br>
	    This attribute can be set to \'yes\' or \'no\'. By default it is set to yes, which means that the contents of the tabs will be contained in a box. If set to no, the box will be removed.</p>

	    <p><strong>pill</strong><br>
	    This attribute allows you to use pill-style navigation instead of regular tabs. Set to yes if you would like pills, the default value is no.</p>

	    <p>The [section] shortcode has just one attribute:</p>

	    <p><strong>title</strong><br>
	    The title of the section which will be used in the tab.</p><a href="http://bonsaished.com/blog/kb/tabs-shortcode/">View Examples Online</a>

	    <div class="separator"></div>

	    <h4>Accordion Shortcode</h4>

	    <h5>[accordion][section][/section][/accordion]</h5>

	    <p>An accordion is very similar to a tab, but has a vertical orientation. It is similarly useful for displaying more content in smaller spaces. To create an accordion you will need to use the [accordion] shortcode and the [section] shortcode. The setup is exactly the same as before, but the accordion shortcode does not have any parameters. The section shortcode has a title parameter which you must fill out. The parameters of this shortcode are:</p>

	    <p><strong>background</strong><br>
	    The title of the section which will be used in the accordion</p><a href="http://bonsaished.com/blog/kb/accordion-shortcode/">View Examples Online</a>

	    <div class="separator"></div>



	    <h4>Slideshow</h4>

	    <h5>[slideshow]</h5>

		<p>A slideshow enables you to show off a number of images in style. Users will be able to flick through the slideshow and navigate it via the navigation dots on the bottom. Slideshows have just one parameter which allows you to add the images you need. If you omit this parameter, all images beloning to the post in question will be used. If you don\'t know what shortcodes are we recommend you read our article on <a href="http://bonsaished.com/blog/kb/how-to-use-shortcodes/">How to Use Shortcodes</a>.</p>
		<p><strong>ids</strong><br>
		Add a comma separated list of image ids. The easiest way to add the images you need is to actually create a WordPress gallery first. If you don\'t know how to do this, refer to our article about <a href="http://bonsaished.com/blog/kb/uploading-and-using-media/">Uploading and Using Media</a>. Once you\'ve created the gallery just rename the shortcode from <code>gallery</code> to <code>slideshow</code></p>

		<a href="http://bonsaished.com/blog/kb/slideshow-shortcode/">View Examples Online</a>

	    <div class="separator"></div>


	    <h4>Postlist Shortcode</h4>

	    <h5>[postlist]</h5>


		<p>
		Postlists enable you to add a list of posts from different post types into a page. By adding some parameters you can control exactly what is shown. If you don\'t know what shortcodes are we recommend you read our article on <a href="http://bonsaished.com/blog/kb/how-to-use-shortcodes/">How to Use Shortcodes</a>. The postlist shortcode has a number of parameters:
		</p>

		<strong>post_type</strong>
		<p>
		Determines the type of post to show. Muscio allows you to add the following post types: <code>post</code>, <code>album</code>, <code>event</code>. If omitted, <code>post</code> will be used.
		</p>

		<strong>post_status</strong>
		<p>By default only published posts are shown. However, if you want to show upcoming posts you can do so here. This parameter supports the following values: <code>publish</code>, <code>future</code>, <code>draft</code>.
		</p>
		<strong>count</strong>
		<p>
		Define how many posts you would like to show. By default 3 will be used. You can use -1 to retrieve all posts but beware, if you have a lot of posts it will take a long time to load!
		</p>

		<a href="http://bonsaished.com/blog/kb/postlist-shortcode/">View Examples Online</a>

	    <div class="separator"></div>


	    <h4>Button Shortcode</h4>

	    <h5>[button][/button]</h5>

	    <p>Creating nicely formatted buttons is extremely easy with the button shortcode. Just wrap it around any text to make it look like a button. You can specify a URL to actually make it work as a button and you can adjust various style settings. The parameters of this shortcode are:</p>

	    <p><strong>url</strong><br>
	    The URL the user is taken to when the button is clicked</p>

	    <p><strong>background</strong><br>
	    The background color of the button. See the section above on using colors for what values you can add here.</p>

	    <p><strong>color</strong></p>

	    <div>
	        The text color of the button.&nbsp;See the section above on using colors for what values you can add here.

	        <p></p>

	        <p><strong>gradient</strong><br>
	        If set to \'yes\' a subtle gradient will be generated based on the background color. The default value is \'no\'.</p>

	        <p><strong>radius</strong><br>
	        If you would like a rounded button you can set the radius here. By default it is set to \'0px\'. If you would like a subtle rounded corner use a small value like \'3px\'. if you want heavily rounded corners use something like \'3px\'. Don\'t &nbsp;forget to add the \'px\' part!</p>

	        <p><strong>arrow</strong><br>
	        If set to \'yes\', an arrow will be generated on the right of the button. The color of this arrow will be the same as the given text color. By default it is set to \'no\'</p><a href="http://bonsaished.com/blog/kb/button-shortcode/">View Examples Online</a>

	        <div class="separator"></div>

	        <h4>Highlight Shortcode</h4>

	        <h5>[highlight][/highlight]</h5>

	        <p>The highlight shortcode allows you to highlight bits of your text in the post content. This is useful for making something stand out, or separating some content from the rest for some other reason. You can modify the color of the highlight using attributes. The parameters of this shortcode are:</p>

	        <p><strong>background</strong><br>
	        The background color of the highlight. See the section above on using colors for what values you can add here.</p>

	        <p><strong>color</strong><br>
	        The text color of the highlight.&nbsp;See the section above on using colors for what values you can add here.</p><a href="http://bonsaished.com/blog/kb/highlight-shortcode/">View Examples Online</a>

	        <div class="separator"></div>

	        <h4>Message Shortcode</h4>

	        <h5>[message][/message]</h5>

	        <p>The message shortcode is another helpful tool for making some content stick out. It is great for putting up notices, warnings and other relevant information that you want to draw the user\'s attention to. Using attributes you can change some properties of the display. The parameters of this shortcode are:</p>

	        <p><strong>background</strong><br>
	        The background color of the message. See the section above on using colors for what values you can add here.</p>

	        <p><strong>color</strong><br>
	        The text color of the message.&nbsp;See the section above on using colors for what values you can add here.</p>

	        <p><strong>radius</strong><br>
	        If you would like a rounded message you can set the radius here. By default it is set to \'0px\'. If you would like a subtle rounded corner use a small value like \'3px\'. if you want heavily rounded corners use something like \'3px\'. Don\'t &nbsp;forget to add the \'px\' part!</p><a href="http://bonsaished.com/blog/kb/message-shortcode/">View Examples Online</a>
	        </p>

	', THEMENAME );
}




/***********************************************/
/*                8. Integrations              */
/***********************************************/

// 8.1 Twitter Integration
add_action( 'wp_head', COMPANYPREFIX . '_twitter_integration' );
function bsh_twitter_integration() {
?>
	<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src="//platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");</script>

<?php
}


// 8.2 Facebook Integration

add_action( 'wp_footer', COMPANYPREFIX . '_facebook_integration' );
function bsh_facebook_integration() {
	$api_key = get_theme_mod( 'facebook_api_key' );
	$api_key = ( empty( $api_key ) ) ? BSH_FACEBOOK_API_KEY : $api_key;

	?>
	<script>(function(d, s, id) {
	  var js, fjs = d.getElementsByTagName(s)[0];
	  if (d.getElementById(id)) return;
	  js = d.createElement(s); js.id = id;
	  js.src = "//connect.facebook.net/en_US/all.js#xfbml=1&appId=<?php echo $api_key ?>";
	  fjs.parentNode.insertBefore(js, fjs);
	}(document, 'script', 'facebook-jssdk'));</script>
	<?php
}

// 8.3 Twitter API

add_action( 'init', COMPANYPREFIX . '_twitter_api' );
function bsh_twitter_api() {
	global $cb;
	$consumer_key = get_theme_mod( 'twitter_consumer_key' );
	$consumer_key = ( empty( $consumer_key ) ) ? BSH_TWITTER_CONSUMER_KEY : $consumer_key;
	$consumer_secret = get_theme_mod( 'twitter_consumer_secret' );
	$consumer_secret = ( empty( $consumer_secret ) ) ? BSH_TWITTER_CONSUMER_SECRET : $consumer_secret;
	$access_token = get_theme_mod( 'twitter_access_token' );
	$access_token = ( empty( $access_token ) ) ? BSH_TWITTER_ACCESS_TOKEN : $access_token;
	$access_secret = get_theme_mod( 'twitter_access_secret' );
	$access_secret = ( empty( $access_secret ) ) ? BSH_TWITTER_ACCESS_SECRET : $access_secret;

	require_once ('framework/external/Codebird/Codebird.class.php');
	Codebird::setConsumerKey( $consumer_key, $consumer_secret );
	$cb = Codebird::getInstance();
	$cb->setToken( $access_token, $access_secret );

}

// Declare WooCommerce Support
add_theme_support( 'woocommerce' );

remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
add_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 120 );

add_action( 'woocommerce_before_main_content', 'mus_woocommerce_before_main_content', 99 );

function mus_woocommerce_before_main_content(){
	if( bsh_has_sidebar() ) {	
		echo '<div class="row"><div class="columns ' . bsh_content_classes() . '">';
	}
	else {
		echo '<div class="row"><div class="columns twelve">';
	}
}


add_action( 'woocommerce_after_main_content', 'mus_woocommerce_after_main_content', 1 );

function mus_woocommerce_after_main_content(){

	if( bsh_has_sidebar() ) {
		echo '</div>';
		echo "<div id='siteSidebar' class='four columns " . bsh_sidebar_classes() . "'>";
			dynamic_sidebar( bsh_get_sidebar() );
		echo "</div></div>";

	}
	else {
		echo '</div></div>';
	}
}

remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar' );


?>