/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file contains most of the specific
	javascript for the theme frontend.

*/

/***********************************************/
/*              Table of Contents              */
/***********************************************/
/*

	1. Initial Variables

	2. Functions
		2.1 Quote Rotator Function
		2.2 Quote Rotation Started Method
		2.3 Quote Rotation Stopper Method
		2.4 Set Menu Template Width
		2.5 Menu Template Height
		2.6 Page Title Formatting

	3. Initial Setup
		3.1  Initial Variables
		3.2  Foundation Elements
		3.3  Element Beautification
		3.4  Javascript Navigation
		3.5  Tile Setup
		3.6  Header Quote Start
		3.7  Submit Behavior
		3.8  Menu Setup
			 3.8.1 Set Menu Width
			 3.8.2 Next Page Click
			 3.8.3 Previous Page Click
			 3.8.4 Set Menu Height
		3.9  Header Menu Arrow
		3.10 Page Title Formatting

	4. On Resize Actions
		4.1 Hidden Custom Select Widths
		4.2 Content Only Slider Height
		4.3 Menu Template Width
		4.3 Page Title Formatting

*/

/***********************************************/
/*             1. Initial Variables            */
/***********************************************/


jQuery( document ).ready( function( $ ) {

	/***********************************************/
	/*               3. Initial Setup              */
	/***********************************************/

	// 3.2 Foundation Elements
	var $doc = $(document), Modernizr = window.Modernizr;
	$.fn.foundationAlerts           ? $doc.foundationAlerts() : null;
	$.fn.foundationTooltips         ? $doc.foundationTooltips() : null;
    $.fn.foundationAccordion        ? $doc.foundationAccordion() : null;
    $.fn.foundationTabs             ? $doc.foundationTabs({callback : $.foundation.customForms.appendCustomMarkup}) : null;

	// 3.3 Element Beautification
	$( '.select-load' ).addClass('shown');
	$('.menu-select').show();
	$( 'select').customSelect();
	$('.menu-select').hide();
	$( '.select-load' ).removeClass('shown');
	$('input[type="submit"]').not('.vfb-submit, .woocommerce input[type="submit"]').customSubmit();
	$( '.nojs' ).removeClass( 'nojs' ).addClass( 'js' );

	// 3.7 Submit Behavior
	$( '.button.submit' ).on( 'click', function(){
		$(this).parents( 'form' ).submit();
	});

	$( '.bonsaiPlayer' ).bonsaiPlayer();

	jQuery('#headerMenu > div > ul > li').hover(
	    function () {
	        var submenuheight = jQuery(this).find('ul:first').attr('submenuheight');
	        if (!submenuheight) {
	            var submenuheight = jQuery(this).find('ul:first').outerHeight();
	            jQuery(this).find('ul:first').attr('submenuheight', submenuheight)
	        }

	        jQuery(this).find('ul:first').show(0).height('0px').stop().animate({
	            height: submenuheight
	        }, 200);
	    },
	    function () {
	        jQuery(this).find('ul:first').css('display', 'block').stop().animate({
	            height: '0px'
	        }, 200).hide(0);
	    }
	);

	jQuery( '.layout-event .share .facebook' ).on( 'click', function() {
		FB.ui(
		  {
		   method: 'feed',
		   name: jQuery(this).parent().attr('data-name'),
		   description: (
		      jQuery(this).parent().attr('data-description')
		   ),
		   link: jQuery(this).parent().attr('data-link'),
		  },
		  function(response) {}
		);
	})

	jQuery(".gallery-item a").fancybox();


	function get_gallery_width( element ) {
		var gallery_width = element.parents('.columns:first').width();
		var column_width = '';
		var width = '';
		if( jQuery(window).width() < 500 ) {
			width = 420;
			$('.gallery-item').css('width', '100%')
		}
		else {
			column_width = gallery_width / 3
			width = Math.floor(element);
			$('.gallery-item').css('width', '33%')
		}
		return width;
	}


	jQuery(window).load( function(){
		sidebar_height();
		jQuery('.gallery').each( function() {
			var gallery = jQuery(this)
			gallery.isotope({
				itemSelector : '.gallery-item',
				resizeable: false,
				layoutMode : 'masonry',
				masonry: {
					columnWidth: get_gallery_width( gallery ),
				},

			});
		})
	})


	jQuery(window).smartresize(function(){
		sidebar_height();
		jQuery('.gallery').each( function() {
			var gallery = jQuery(this)
			gallery.isotope({
				masonry: {
					columnWidth: get_gallery_width( gallery ),
				},

			});
		})

	});

	jQuery( '#launchPlayer, .launchPlayer' ).click( function () {

		if( jQuery('.bonsaiPlayer' ).is(':visible') ) {
			jQuery( '.bonsaiPlayer' ).fadeOut( function() {
				jQuery('#siteHeader, #siteContainer, #siteFooter').fadeIn()
				jQuery( '#launchPlayer' ).html( jQuery( '#launchPlayer' ).attr( 'data-open_text' ) )
			})
		}
		else {
			jQuery('#siteHeader:visible, #siteContainer:visible, #siteFooter:visible').fadeOut( function() {
				jQuery( '.bonsaiPlayer' ).fadeIn()
				jQuery( '#launchPlayer' ).html(jQuery( '#launchPlayer' ).attr( 'data-close_text' ))
			});

		}
		return false;

	})


	jQuery( '#headerMenu select' ).on( 'change', function(){
		if( jQuery(this).attr('name') == 'page_id' ) {
			window.location = mus.url + '?p=' + jQuery(this).val();
		}
		else {
			window.location = jQuery(this).val();
		}
	})

	if ( jQuery('.bonsaiPlayer' ).length > 0 ) {
		jQuery(document).on( 'click', 'a', function() {
			if( jQuery(".jplayer").data("jPlayer").status.paused === false ) {
				var target = jQuery(this).attr( 'href' );
				if( substr_count( target, mus.url) > 0 && jQuery(this).attr('rel') != 'lightbox' ) {
					jQuery.ajax({
						url: target,
						beforeSend: function() {
							show_page_loader();
						},
						success: function(response){
							var page = jQuery( response );
							var element;
							page.each( function() {
								element = jQuery( this )
								if( element.attr('id') === 'musicoSiteContentContainer' ) {
									jQuery( '#musicoSiteContentContainer' ).html( element.html())

								}
							})
							hide_page_loader();

						}
					})
				}

				return false;
			}
		})
	}

});


function sidebar_height() {
	jQuery( '#siteSidebar' ).css('height', 'auto')
	var sidebar_height = jQuery( '#siteSidebar' ).height();
	var container_height = jQuery( '#siteContainer' ).height();

	if( container_height > sidebar_height ) {
		jQuery( '#siteSidebar' ).height( container_height );
	}
	else {
		jQuery( '#siteContainer' ).height( sidebar_height )
	}
}

function show_page_loader() {
	jQuery( '#musicoSiteContentContainerLoader' ).show();
	var top = jQuery(window).scrollTop();
	var height = jQuery(window).height();
	var loadTop = top + ( ( height - 100 ) / 2 );
	jQuery( '#musicoSiteContentContainerLoader' ).css('background-position-y', loadTop + 'px')
}

function hide_page_loader() {
	jQuery( '#musicoSiteContentContainerLoader' ).hide();
}

function substr_count (haystack, needle, offset, length) {
  var cnt = 0;

  haystack += '';
  needle += '';
  if (isNaN(offset)) {
    offset = 0;
  }
  if (isNaN(length)) {
    length = 0;
  }
  if (needle.length == 0) {
    return false;
  }
  offset--;

  while ((offset = haystack.indexOf(needle, offset + 1)) != -1) {
    if (length > 0 && (offset + needle.length) > length) {
      return false;
    }
    cnt++;
  }

  return cnt;
}