;(function($){ $.fn.extend({
	bonsaiPlayer : function(options) {
		var defaults = {
		};

		var options = $.extend(defaults, options);

		var $bonsaiPlayer = this;
		var $jplayer      = this.find( '.jplayer' );
		var $currentTime  = this.find( '.player .play-time' );
		var $totalTime    = this.find( '.player .total-time' );
		var $playBar      = this.find( '.player .play-bar' );
		var $volumeBar    = this.find( '.player .volume' );
		var $playlist     = this.find( '.playlist' );


		$jplayer.jPlayer({
			oggSupport	: false,
			preload		: 'auto',
			swfPath: mus.template_url + '/javascripts/source/external/',
	        solution: 'html, flash',
			timeupdate : function() {
				currentTime = $jplayer.data('jPlayer').status.currentTime;
				totalTime = $jplayer.data('jPlayer').status.duration;
				currentPercent = $jplayer.data('jPlayer').status.currentPercentAbsolute;

				$playBar.css( 'width', currentPercent + '%' );
				$currentTime.text($.jPlayer.convertTime(currentTime));
				$totalTime.text($.jPlayer.convertTime(totalTime));

			},
			play: function() {
				$bonsaiPlayer.find( '.player .play, .player .unpause' ).hide();
				$bonsaiPlayer.find( '.pause' ).show();
			},
			pause: function() {
				$bonsaiPlayer.find( '.player .play, .player .pause' ).hide();
				$bonsaiPlayer.find( '.unpause' ).show();
			},
			ended: function() {
				next()
			}

		})

		$playlist.sortable();
		$playlist.disableSelection();


		$('.albumlist').flexslider({
			animation: "slide",
			animationLoop: false,
			itemWidth: 160,
			itemMargin: 10,
			controlNav: false,
			slideshow: false
		});



		/*********************************/
		/*     Playlist Manipulation     */
		/*********************************/

		function songPlay( song_id, title, mp3) {
			$playlist.empty();

			var song_html = "<span class='remove'></span><a href='#'>" + title + "</a>";
			song_html 	 += "<div class='mp3' style='display:none;'>" + mp3 + "</div>";

			var $listItem = $("<li/>",{
				id			  : song_id,
				html 		  : song_html
			});
			$listItem.addClass('current');

			$playlist.append($listItem);

			$listItem.find('.remove').bind( 'click', removeSong );
			$listItem.find('a').bind( 'click', playlistSongPlay );

		}


		function songAdd( song_id, title, mp3 ) {
			var $list_count = $playlist.find('li').length;

			if( $playlist.find( '#' + song_id ).length ) {
				return;
			}

			var songClass = '';
			if( $list_count == 0 ) {
				songClass = 'current';
			}
			var song_html = "<span class='remove'></span><a href='#'>" + title + "</a>";
			song_html 	 += "<div class='mp3' style='display:none;'>" + mp3 + "</div>";

			var $listItem = $("<li/>",{
				id			: song_id,
				html 		: song_html
			});
			$listItem.addClass(songClass);

			$playlist.append( $listItem );

			$listItem.find('.remove').bind( 'click', removeSong );
			$listItem.find('a').bind( 'click', playlistSongPlay );

		}

		function removeSong() {
			$track = $(this).parents( 'li' );

			var playNext = false;
			var $list_count = $playlist.find('li').length;

			if( $list_count > 1 && $track.hasClass( 'current' ) ) {
				playNext = true;
			}

			if( $list_count === 1 ) {
				stop();
			}

			if( playNext === true ) {
				next();
			}

			$track.remove();

			return false;
		}

		function playlistSongPlay() {
			var $this = $(this);
			var mp3 = $this.next().html();

			$playlist.find( 'li' ).removeClass( 'current' )
			$this.parents( 'li:first' ).addClass( 'current' );

			play( mp3 );
			return false;
		}



		/*********************************/
		/*       Audio manipulation      */
		/*********************************/

		function play( mp3 ) {
			var $list_count = $playlist.find('li').length;

			if( $list_count === 0 ) {
				return;
			}

			if( mp3 === '' || mp3 === null || typeof mp3 === 'undefined' ) {
				var $current = $playlist.find( 'li.current' );
				if( $current.length === 0 ) {
					next();
				}
				else {
					mp3 = $current.find( '.mp3' ).html();
				}
			}


			$jplayer.jPlayer("setMedia", { mp3 : mp3 } ).jPlayer("play");
		}

		function stop() {
			$jplayer.jPlayer("clearMedia")
		}

		function pause() {
			$jplayer.jPlayer("pause")
		}

		function unpause() {
			$jplayer.jPlayer("play")
		}

		function next() {
			var $current = $playlist.find( 'li.current' );
			var $next = $current.next();

			if( $next.length === 0 ) {
				$next = $playlist.find( 'li:first' );
			}

			$current.removeClass( 'current' );
			$next.addClass( 'current' );

			var mp3 = $next.find( '.mp3' ).html();
			play( mp3 );
		}

		function previous() {
			var $current = $playlist.find( 'li.current' );
			var $previous = $current.prev();

			if( $previous.length === 0 ) {
				$previous = $playlist.find( 'li:last' );
			}

			$current.removeClass( 'current' );
			$previous.addClass( 'current' );

			var mp3 = $previous.find( '.mp3' ).html();
			play( mp3 );
		}


		/*********************************/
		/*         Misc Functions        */
		/*********************************/

		function get_track_details( track ) {

			var details = [];

			details.mp3         = track.find( '.mp3' ).html();
			details.title   	= track.find( 'h2' ).html();

			var album_id    	= track.parents('.album').attr('id');
			var song_index	    = track.index();
			details.song_id  	= album_id + '_' + song_index;

			return details;
		}

		function setVolume( vol ) {
			var percentage = vol*100;
			$volumeBar.css( 'width', percentage + '%' );
		}


		/*********************************/
		/*            Events             */
		/*********************************/

		// Play a single song
		$('.track .play').bind('click',function(){
			var $this = $(this);
			var track = get_track_details( $this.parents( '.track' ) )

			songPlay( track.song_id, track.title, track.mp3 );
			play( track.mp3 );
		});

		// Add a single song
		$('.track .add').bind('click',function(){
			var $this = $(this);
			var track = get_track_details( $this.parents( '.track' ) )

			songAdd( track.song_id, track.title, track.mp3 );

			if( $playlist.find('li').length === 1 ) {
				play( track.mp3 );
			}
		});

		// Add all songs in album
		$('.cover').bind('click',function(){
			var $this 		= $(this);
			var $album		= $this.parents( '.album' );
			var track       = '';
			var playFirst   = false;
			var firstTrack  = [];

			if( $playlist.find('li').length === 0 ) {
				playFirst = true;
			}

			$.each( $album.find( '.track .add' ), function( i ) {
				track = get_track_details( $(this).parents( '.track' ) );
				songAdd( track.song_id, track.title, track.mp3 );

				if( i === 0 ) {
					firstTrack = track;
				}

			})

			if( playFirst === true ) {
				play( firstTrack.mp3 );
			}

		})

		// Go to next song

		$( '.player .next' ).bind( 'click', function(){
			next();
			return false;
		})

		$( '.player .previous' ).bind( 'click', function(){
			previous();
			return false;
		})

		$( '.player .stop' ).bind( 'click', function(){
			stop();
			return false;
		})

		$( '.player .play' ).bind( 'click', function(){
			play();
			return false;
		})

		$( '.player .pause' ).bind( 'click', function(){
			pause();
			return false;
		})

		$( '.player .unpause' ).bind( 'click', function(){
			unpause();
			return false;
		})

		$( '.player .volume-min' ).bind( 'click', function(){
			setVolume( 0 );
			return false;
		})

		$( '.player .volume-max' ).bind( 'click', function(){
			setVolume( 1 );
			return false;
		})

		$( '.player .volume-bar' ).bind( 'click', function(e){

			var parentOffset = $(this).offset();
			var x = e.pageX - parentOffset.left;
			var volume = x/50;
			setVolume( volume );

			return false;
		})


		$( '.albumlist li img' ).not('.flex-next').bind( 'click', function(){
			$('.albums .album:visible').hide();
			$item = $(this).parents('li:first');
			$('.albums').find( '.album:nth-child(' + parseInt($item.index()+1) + ')').fadeIn(1000)
		})





	}



}); })(jQuery);