<?php
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file is responsible for displaying
	the list form of events.

*/

$location = get_post_meta( $post->ID, '_mus_location', true );
$time = get_post_meta( $post->ID, '_mus_time', true );
$date_placeholder = get_post_meta( $post->ID, '_mus_date_placeholder', true );
$venue = get_post_meta( $post->ID, '_mus_venue', true );
$ticket_url = get_post_meta( $post->ID, '_mus_ticket_url', true );
$ticket_text = get_post_meta( $post->ID, '_mus_ticket_text', true );

?>
<article <?php post_class( 'layout-event-item list-item' ) ?>>

	<?php if( has_post_thumbnail() ) : ?>
		<a class='hoverlink' title='<?php _e( 'Click here to view the details of this event', THEMENAME ) ?>' href='<?php the_permalink() ?>'><?php the_post_thumbnail( 'mus_large' ) ?></a>
	<?php endif ?>
	<h1 class='layout-title'><a title='<?php _e( 'Click here to view the details of this event', THEMENAME ) ?>' href='<?php the_permalink() ?>'><?php the_title() ?></a></h1>

	<div class='metas'>
		<?php if( !empty( $location ) OR ( !empty( $venue ) ) ) : ?>
			<span class='meta location'><?php echo $location ?>
			<?php if( !empty( $venue ) ) : ?>
			- <?php echo $venue ?>
			<?php endif ?>
			</span>
		<?php endif ?>
		<span class='meta time'>
			<?php
				if( empty( $time ) ) {
					echo $date_placeholder;
				}
				else {
					echo date( 'F dS, Y H:i', strtotime( $time ) );
				}
			?>
		</span>
	</div>

	<div class='content'>
			<?php
				$content_type = get_theme_mod( 'list_content_type' );
				if( $content_type === 'content' ) {
					the_content();
				}
				else {
					the_excerpt();
					?>
					<a class='primary' title='<?php _e( 'Click here to view the details of this event', THEMENAME ) ?>' href='<?php the_permalink() ?>'><?php echo get_theme_mod( 'read_more_text' ) ?></a>

					<?php
				}
			?>
	</div>

</article>