<?php
/***********************************************/
/*               About This File               */
/***********************************************/
/*
	This file is responsible for displaying
	the list form of posts

*/
?>
<article <?php post_class( 'layout-post-item list-item' ) ?>>

	<?php if( has_post_thumbnail() ) : ?>
		<a class='hoverlink' title='<?php _e( 'Click here to read this post in full', THEMENAME ) ?>' href='<?php the_permalink() ?>'><?php the_post_thumbnail( 'mus_large' ) ?></a>
	<?php endif ?>
	<h1 class='layout-title'><a title='<?php _e( 'Click here to read this post in full', THEMENAME ) ?>' href='<?php the_permalink() ?>'><?php the_title() ?></a></h1>

	<div class='metas primary-links'>

		<span class='meta date'><span class='icon date'></span> <?php the_time( 'F j, Y' ) ?></span>

		<?php if( has_tag() ) : ?>
		 <span class='meta tags'><span class='icon tags'></span> <?php the_tags('', ', ') ?></span>
		<?php endif ?>

		<?php if( has_category() ) : ?>
		 <span class='meta categories'><span class='icon category'></span> <?php the_category(', ') ?></span>
		<?php endif ?>

		<?php if( comments_open() ) : ?>
		<span class='meta comments'>
			<span class='icon comment'></span>
			<a class='primary' href="<?php comments_link(); ?>"><?php echo comments_number( __( '0 comments', THEMENAME ), __( '1 comment', THEMENAME ), __( '% comments', THEMENAME ) ) ?></a>
		</span>
		<?php endif ?>

	</div>

	<div class='content'>
			<?php
				$content_type = get_theme_mod( 'list_content_type' );
				if( $content_type === 'content' ) {
					the_content();
				}
				else {
					the_excerpt();
					?>
					<a class='primary' title='<?php _e( 'Click here to read this post in full', THEMENAME ) ?>' href='<?php the_permalink() ?>'><?php echo get_theme_mod( 'read_more_text' ) ?></a>
					<?php
				}
			?>
	</div>

</article>