<?php
if( get_theme_mod( 'albumplayer' ) != 'no' ) :

$temp_query = $wp_query;
$wp_query = null;
$wp_query = new WP_Query( array( 'post_type' => 'album', 'post_status' => 'publish', 'posts_per_page' => -1 ) );
?>


<div class='bonsaiPlayer'>

	<div class='player'>
		<div class='jplayer'></div>
		<ul class='controls'>
			<li><a href='#' class='previous'></a></li>
			<li><a href='#' class='play'></a><a href='#' style='display:none' class='pause'></a><a href='#' style='display:none'class='unpause'></a></li>
			<li><a href='#' class='next'></a></li>
			<li><a href='#' class='stop'></a></li>
			<li><a href='#' class='volume-min'></a></li>
			<li class='volume-bar'><div class='volume'></div></li>
			<li><a href='#' class='volume-max'></a></li>
		</ul>

		<div class='volume-bar'><div class='volume-bar-value'></div></div>

		<div class='progress-bar'><div class='play-bar'></div></div>

		<div class='times'>
			<div class='play-time'></div>
			<div class='total-time'></div>
		</div>

		<ul class='playlist'></ul>

		<?php if( !have_posts() ) : ?>
			<?php _e( '<div class="content"><p>Once there are songs to listen to you\'ll be able to control the playback from here</p></div>', THEMENAME ) ?>
		<?php endif ?>

	</div>


	<div class='albums'>

	<?php
		if( have_posts() ) :
		while( have_posts() ) : the_post();
	?>


		<div class="album" id="album-<?php the_ID() ?>">

			<div class='cover'>
				<?php the_post_thumbnail( 'album' ) ?>
			</div>

			<div class='tracks'>

				<?php
					$tracks = mus_get_tracks( $post->ID );
					if( !empty( $tracks ) ) :
					foreach( $tracks as $track ) :

				?>

					<div class='track'>
						<div class='controls'>
							<span class='play'></span>
							<span class='add'></span>
						</div>
						<h2 class='body-font'><?php echo $track->post_title ?></h2>
						<div class='data'>
							<span class="title"><?php echo $track->post_title ?></span>
							<span class="mp3"><?php echo $track->guid ?></span>
						</div>
					</div>

				<?php endforeach; else : ?>
					<?php _e( '<div class="content"><p>There are no tracks for this album yet!</p></div>', THEMENAME ) ?>
				<?php endif ?>

			</div>


			<div class="album-info">
				<h1><?php the_title() ?></h1>
				<div class='content'>
					<?php the_excerpt() ?>
				</div>
			</div>

		</div>

		<?php
			endwhile;
			rewind_posts();
			else :
		?>
			<?php _e( '<div class="content"><p>There are no albums to play yet! Once albums are added you will be able to see their info here and listen to the songs from the album.</p></div>', THEMENAME ) ?>
		<?php endif ?>

	</div>

	<?php if( have_posts() AND $wp_query->found_posts > 1 ) : ?>
	<div class='flexslider albumlist'>
		<ul class='slides'>
		<?php
			while( have_posts() ) {
				the_post();
				$thumbnail_id = get_post_thumbnail_id();
				$image = wp_get_attachment_image_src( $thumbnail_id );
				echo '<li><img src="' . $image[0] . '"></li>';
			}
		?>
		</ul>
	</div>
	<?php endif ?>

	<?php
		$wp_query = $temp_query;
		wp_reset_postdata();
	?>
</div>
<?php endif ?>