<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class WC_AF_Rule_High_Value extends WC_AF_Rule {

	/**
	 * The constructor
	 */
	public function __construct() {
		parent::__construct( 'high_value', sprintf( 'Order has a total higher than %s times the average order.', apply_filters( 'wc_af_high_value_multiplier', 2 ) ), 15 );
	}

	/**
	 * Do the required check in this method. The method must return a boolean.
	 *
	 * @param WC_Order $order
	 *
	 * @since  1.0.0
	 * @access public
	 *
	 * @return bool
	 */
	public function is_risk( WC_Order $order ) {
		global $wpdb;

		// Default risk is false
		$risk = false;

		// Get the average order total
		$avg_order_total = round( $wpdb->get_var( "SELECT AVG(PM.`meta_value`)
 			FROM $wpdb->postmeta PM
 			INNER JOIN $wpdb->posts P ON P.`ID` = PM.`post_id`
 			WHERE PM.`meta_key` = '_order_total' AND PM.`meta_value` > 0 AND P.`post_type` = 'shop_order'
		AND P.`post_status` IN ( 'wc-" . implode( "','wc-", apply_filters( 'wc_af_high_value_value_order_statuses', array( 'completed', 'processing', 'on-hold' ) ) ) . "' ) ;" ) );

		// Check if the order total is higher than 2 times the average order total
		if ( ( $avg_order_total > 0 ) && $order->get_total() > ( $avg_order_total * apply_filters( 'wc_af_high_value_multiplier', 2 ) ) ) {
			$risk = true;
		}

		return $risk;
	}

}