<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class WC_AF_Rule_Ip_Multiple_Order_Details extends WC_AF_Rule {

	/**
	 * The constructor
	 */
	public function __construct() {
		parent::__construct( 'ip_multiple_order_Details', 'IP address ordered with multiple order details in the past 30 days', 25 );
	}

	/**
	 * Do the required check in this method. The method must return a boolean.
	 *
	 * @param WC_Order $order
	 *
	 * @since  1.0.0
	 * @access public
	 *
	 * @return bool
	 */
	public function is_risk( WC_Order $order ) {
		global $wpdb;

		// Default risk is false
		$risk = false;

		// Set the default order types
		$order_types = array( 'shop_order' );

		// wc_get_order_types() is a 2.2+ function
		if ( function_exists( 'wc_get_order_types' ) ) {
			$order_types = wc_get_order_types( 'order-count' );
		}

		$order_ip = get_post_meta( $order->id, '_customer_ip_address', true );
		if ( empty( $order_ip ) ) {
			return false;
		}

		// Get the Same IP Orders
		$si_orders = get_posts( array(
				'posts_per_page' => - 1,
				'post_type'      => $order_types,
				'post__not_in'   => array( $order->id ),
				'post_status'    => array( 'wc-completed', 'wc-processing', 'wc-on-hold' ),
				'meta_query'     => array(
					array(
						'key'     => '_customer_ip_address',
						'value'   => $order_ip,
						'compare' => '='
					)
				)
			)
		);

		// Check if there are orders with same IP
		if ( count( $si_orders ) > 0 ) {

			// Loop
			foreach ( $si_orders as $si_order ) {

				// Get WC_Order object
				$si_order_object = wc_get_order( $si_order->ID );

				// Check
				if (
					( $si_order_object->get_formatted_billing_address() != $order->get_formatted_billing_address() )
					||
					( $si_order_object->get_formatted_shipping_address() != $order->get_formatted_shipping_address() )
				) {
					// Set risk
					$risk = true;
				}

			}

		}

		return $risk;
	}

}