<?php
/**
 * @package WordPress
 * @subpackage BuddyBoss Wall
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Format various notifications generated by photos component.
 *
 * @param string $action
 * @param int $item_id
 * @param int $secondary_item_id
 * @param int $total_items
 * @param string $format DEFAULT 'string'
 * 
 * @return mixed
 */
function buddyboss_wall_like_notifier_format_notifications( $action, $item_id, $secondary_item_id, $total_items, $format='string' ) {

	switch ( $action ) {
		case 'new_wall_post_like_'.$item_id:

			$notification_handler = BuddyBoss_Wall_Like_Notification::get_instance();
			$return = $notification_handler->format_bp_notifications( $action, $item_id, $secondary_item_id, $total_items, $format );

			if ( 'string' == $format ) {

				$return = '<a href="' . esc_url( $return['link'] ) . '">' . esc_html( $return['text'] ) . '</a>';
			}
			break;
	}
	return $return;
}