<?php
// @since 7.0.3.12
// @author Dustin Bolton

/*
$recent_send_fails = array(
	'file' => '',
	'log_tail' => '',
	'error' => '',
);
*/


backupbuddy_live_troubleshooting::run();
$results = backupbuddy_live_troubleshooting::get_raw_results();
echo '<pre>';
print_r( $results );
echo '</pre>';



class backupbuddy_live_troubleshooting {
	
	
	private static $_settings = array(
		'max_notifications' => 10,								// Max number of most recent sync notifications to return.
		'status_log_recent_lines' => 50,						// Max number of most recent lines to get from status log.
		'extraneous_log_recent_lines' => 30,					// Max number of most recent lines to get from extraneous overall status log.
		'send_fail_status_log_recent_lines' => 20,				// Max number of most recent lines to get from a REMOTE TRANSFER status log for Stash Live sends that FAILED.
	);
	
	
	private static $_results = array(
		'start_troubleshooting' => 0,
		'finish_troubleshooting' => 0,
		'gmt_offset' => 0,
		'live_status_log_modified' => '',						// Timestamp status log was last modified.
		'live_status_log_modified_ago' => '',					// Time since status log was last modified.
		
		'highlights' => array(),
		'php_notices' => array(),								// Any PHP errors, warnings, notices found in any of the log searched.
		'bb_notices' => array(),								// Any BackupBuddy errors or warnings logged.
		'recent_waiting_on_files' => array(),					// Recent list of files waiting on as per $files_pending_send_file file contents.
		'recent_waiting_on_files_time' => 0,					// File modified time.
		'recent_waiting_on_files_time_ago' => 0,				// File modified time.
		'recent_waiting_on_tables' => array(),					
		'recent_waiting_on_tables_time' => 0,					// File modified time.
		'recent_waiting_on_tables_time_ago' => 0,				// File modified time.
		'recent_live_send_fails' => array(),					// Remote destination send failures to Live.
		'recent_sync_notifications' => array(),					// Sync Notification errors (live_error).
		'live_status_log_tail' => '',							// Recent Stash Live Status Log.
		'live_stats' => array(),
		'server_stats' => array(),
		'crons' => array(),										// Listing of crons for troubleshooting.
		'extraneous_log_tail' => '',							// Tail end of extraneous log file.
		'extraneous_log_modified' => 0,
		'extraneous_log_modified_ago' => '',
	);
	
	
	
	public static function run() {
		self::$_results['start_troubleshooting'] = microtime( true );
		self::$_results['gmt_offset'] = get_option( 'gmt_offset' );
		
		// Recent send fails (remote destination failures).
		// HIGHLIGHTS: PHP errors, send errors, NUMBER of sends failed in X hours
		
		// Populates tail of status log and looks for PHP and BB notices.
		self::_test_status_log();
		self::_test_recent_sync_notifications();
		self::_test_live_state();
		self::_test_server_stats();
		self::_test_cron_scheduled();
		self::_test_recent_live_send_fails();
		self::_test_extraneous_log();
		self::_recent_waiting_on_files_tables();
		
		self::$_results['finish_troubleshooting'] = microtime( true );
	} // End run().
	
	
	
	public static function get_raw_results() {
		return self::$_results;
	}
	
	
	
	public static function get_html_results() {
		echo 'TODO #483948434';
	}
	
	
	
	private static function _recent_waiting_on_files_tables() {
		$files_pending_send_file = backupbuddy_core::getLogDirectory() . 'live/files_pending_send-' . pb_backupbuddy::$options['log_serial'] . '.txt';
		$tables_pending_send_file = backupbuddy_core::getLogDirectory() . 'live/tables_pending_send-' . pb_backupbuddy::$options['log_serial'] . '.txt';
		
		if ( file_exists( $files_pending_send_file ) ) {
			if ( false !== ( $files_pending_send = @file_get_contents( $files_pending_send_file ) ) ) {
				self::$_results['recent_waiting_on_files'] = explode( "\n", $files_pending_send );
				self::$_results['recent_waiting_on_files_time'] = @filemtime( $files_pending_send_file );
				self::$_results['recent_waiting_on_files_time_ago'] = pb_backupbuddy::$format->time_ago( self::$_results['recent_waiting_on_files_time'] ) . ' ' . __( 'ago', 'it-l10n-backupbuddy' );
				if ( count( self::$_results['recent_waiting_on_files'] ) > 0 ) {
					self::$_results['highlights'][] = '`' . count( self::$_results['recent_waiting_on_files'] ) . '` total files recently needed waiting on.';
				}
			}
		}
		if ( file_exists( $tables_pending_send_file ) ) {
			if ( false !== ( $tables_pending_send = @file_get_contents( $tables_pending_send_file ) ) ) {
				self::$_results['recent_waiting_on_tables'] = explode( "\n", $tables_pending_send );
				self::$_results['recent_waiting_on_tables_time'] = @filemtime( $tables_pending_send_file );
				self::$_results['recent_waiting_on_tables_time_ago'] = pb_backupbuddy::$format->time_ago( self::$_results['recent_waiting_on_tables_time'] ) . ' ' . __( 'ago', 'it-l10n-backupbuddy' );
				if ( count( self::$_results['recent_waiting_on_tables'] ) > 0 ) {
					self::$_results['highlights'][] = '`' . count( self::$_results['recent_waiting_on_tables'] ) . '` total tables recently needed waiting on.';
				}
			}
		}
	}
	
	private static function _test_extraneous_log() {
		$status_log_file = backupbuddy_core::getLogDirectory() . 'log-' . pb_backupbuddy::$options['log_serial'] . '.txt';
		$status_log_file_contents = file_get_contents( $status_log_file );
		self::_find_notices( $status_log_file_contents );
		
		// Get tail of status log.
		self::$_results['extraneous_log_tail'] = backupbuddy_core::read_backward_line( $status_log_file, self::$_settings['extraneous_log_recent_lines'] );
		
		// Get modified times.
		self::$_results['extraneous_log_modified'] = filemtime( $status_log_file );
		self::$_results['extraneous_log_modified_ago'] = pb_backupbuddy::$format->time_ago( self::$_results['extraneous_log_modified'] ) . ' ' . __( 'ago', 'it-l10n-backupbuddy' );
	}
	
	private static function _test_status_log() {
		$status_log_file = backupbuddy_core::getLogDirectory() . 'status-live_periodic_' . pb_backupbuddy::$options['log_serial'] . '.txt';
		$status_log_file_contents = file_get_contents( $status_log_file );
		self::_find_notices( $status_log_file_contents );
		
		// Get tail of status log.
		self::$_results['live_status_log_tail'] = backupbuddy_core::read_backward_line( $status_log_file, self::$_settings['status_log_recent_lines'] );
		
		// Get modified times.
		self::$_results['live_status_log_modified'] = filemtime( $status_log_file );
		self::$_results['live_status_log_modified_ago'] = pb_backupbuddy::$format->time_ago( self::$_results['live_status_log_modified'] ) . ' ' . __( 'ago', 'it-l10n-backupbuddy' );
	}
	
	
	
	private static function _test_recent_sync_notifications() {
		$notifications = backupbuddy_core::getNotifications();
		
		// Remove non-Stash Live notifications.
		foreach( $notifications as $key => $notification ) {
			if ( 'live_error' != $notification['slug'] ) {
				unset( $notifications[ $key ] );
				continue;
			}
		}
		
		if ( count( $notifications ) > 0 ) {
			self::$_results['highlights'][] = '`' . count( $notifications ) . '` recent Stash Live Sync error notifications.';
		}
		
		// Limit to X number of most recent notifications.
		self::$_results['recent_sync_notifications'] = array_slice( $notifications, -1 * ( self::$_settings['max_notifications'] ), self::$_settings['max_notifications'], $preserve_key = false );
		
	}
	
	
	
	private static function _test_live_state() {
		self::$_results['live_stats'] = backupbuddy_api::getLiveStats();
	}
	
	
	
	private static function _test_server_stats() {
		require( pb_backupbuddy::plugin_path() . '/controllers/pages/server_info/_server_tests.php' ); // Populates $tests.
		self::$_results['server_stats'] = $tests;
		foreach( self::$_results['server_stats'] as $stat ) {
			if ( ( 'FAIL' == $stat['status'] ) || ( 'WARNING' == $stat['status'] ) ) {
				self::$_results['highlights'][] = $stat;
			}
		}
	}
	
	
	
	private static function _test_cron_scheduled() {
		require( pb_backupbuddy::plugin_path() . '/controllers/pages/server_info/_cron.php' );
		self::$_results['crons'] = $crons;
	}
	
	
	
	private static function _test_recent_live_send_fails() {
		$troubleshooting = true; // Tell _remote_sends.php to run in troubleshooting/text mode.
		require( pb_backupbuddy::plugin_path() . '/controllers/pages/server_info/_remote_sends.php' ); // Populates $sends.
		self::$_results['recent_live_send_fails'] = $sends;
		foreach( self::$_results['recent_live_send_fails'] as $key => &$send ) {
			
			// Only include Live sends.
			if ( 'live' != $send['type'] ) {
				unset( self::$_results['recent_live_send_fails'][ $key ] );
				continue;
			}
			
			// Only include FAILED sends.
			if ( true !== $send['failed'] ) {
				unset( self::$_results['recent_live_send_fails'][ $key ] );
				continue;
			}
			
			// If error message, set as highlight.
			if ( '' != $send['error'] ) {
				self::$_results['highlights'][] = array(
					'error' => 'File send Error #4389844959:' . $send['error'],
					'send_details' => $send
				);
			}
			
			if ( file_exists( $send['log_file'] ) ) {
				$send['log_tail'] = backupbuddy_core::read_backward_line( $send['log_file'], self::$_settings['send_fail_status_log_recent_lines'] );
			}
		}
		
		if ( count( self::$_results['recent_live_send_fails'] ) > 0 ) {
			self::$_results['highlights'][] = count( self::$_results['recent_live_send_fails'] ) . ' total files pending send before Snapshot can be made.';
		}
	}
	
	
	
	/* _find_notices()
	 *
	 * Finds any PHP errors, warnings, notices + BackupBuddy errors and warnings in a log file.
	 *
	 */
	private static function _find_notices( $log ) {
		$php_notices = array();
		$bb_notices = array();
		
		self::$_results['highlights'][] = 'TODO #8493484: Auto-detect PHP and BackupBuddy alerts and errors and highlight here.';
		// TODO: loop through file, searching each line.
		// TODO: When notice found, add to appropriate location.
		// TODO: highlight: fatal PHP error
		// TODO: highlight: out of memory error
		// TODO: highlight: BackupBuddy Error #
		
		//self::$_results['php_notices']
		//self::$_results['bb_notices']
		
		return array( $php_notices, $bb_notices );
	}
	
	
	
} // End class.

